#pragma once

#include "BaseMenu.h"
#include "MenuHelpers.h"

class IGameContext;

class ISelectLevelCallback
{
public:
	virtual void BackFromSelectLevel() = 0;
	virtual void StartLevel( int levelIndex ) = 0;
};

  // This menu allows player to select level to start from (for Casual mode)
class MenuSelectLevel : public BaseMenu, public SimpleMenuEntry::ICallback
{
	static const int EID_BACK			= -1;
	static const int EID_LOCKED			= -2;

	ISelectLevelCallback *m_pCallback;
	SimpleMenuEntry m_back;

	friend class LevelsEnumerator;

	void Clear();

public:
	MenuSelectLevel( int x, int y, ISelectLevelCallback *pCallback )
		: BaseMenu( "OptionsMenu", 450, 256 )
		, m_pCallback( pCallback )
		, m_back			( this, 255, "Back",				Color(255,255,255), EID_BACK,			this )
	{
	}

	void operator()( int id );
	void Back() { this->operator ()( EID_BACK ); }

	void ReInit( IGameContext & context );
};
