#include "stdafx.h"
#include "SelectLevelMenu.h"
#include "GameContext.h"

  // Class that bassed to IGameContext to get
  // list of levels for displaying in Level Select menu
class LevelsEnumerator : public ILevelsEnumerator
{
	MenuSelectLevel *m_pMenu;
public:
	LevelsEnumerator( MenuSelectLevel *pMenu )
		: m_pMenu( pMenu )
	{}

	void operator()( const char *levelName, int index, bool locked )
	{
		if ( index <= 0 )
			return;

		if ( locked )
		{
			SimpleMenuEntry *pLevel = new SimpleMenuEntry( m_pMenu, index, "--LOCKED--", Color(255,255,255), MenuSelectLevel::EID_LOCKED, m_pMenu );
		}
		else
		{			
			SimpleMenuEntry *pLevel = new SimpleMenuEntry( m_pMenu, index, levelName, Color(255,255,255), index, m_pMenu );
			m_pMenu->SetSelected( pLevel );
		}
	}
};

void MenuSelectLevel::ReInit( IGameContext & context )
{
	Clear();
	
	AddEntry( &m_back );

	LevelsEnumerator e( this );
	context.EnumerateLevels( e );
}

void MenuSelectLevel::Clear()
{
	for( BaseMenu::EntryVector::iterator iter = m_entries.begin();
		 iter != m_entries.end();
		 ++iter )
	{
		if ( *iter != &m_back )
			delete *iter;
	}
	m_entries.clear();
}

void MenuSelectLevel::operator()( int id )
{
	if ( id == EID_BACK )
		m_pCallback->BackFromSelectLevel();
	else if ( id != EID_LOCKED )
		m_pCallback->StartLevel( id );
}
