#include "stdafx.h"
#include "MenuHelpers.h"
#include "IInput.h"

void TextMenuEntry::Render( IRender *pRender, int x, int y )
{
	pRender->DrawText( x, y, m_selected ? pRender->MakeColor( 255, 255, 0 ) : m_color, 16, "%s", m_label.c_str() );
}

void SimpleMenuEntry::ProcessInput( IInput *pInput )
{
	pInput->BeginRead();
	while( true )
	{
		InputEvent ev = pInput->GetEvent();
		if ( ev.m_type == InputEvent::EV_INVALID )
			break;

		if ( ev.m_type == InputEvent::EV_KEYBOARD && ev.m_keyboardEvent.m_type == KeyboardEvent::KBD_KEY_UP )
		{
			if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_ENTER )
			{
				if ( m_pCallback )
					(*m_pCallback)( m_callbackID );

				pInput->PopEvent();
				continue;
			}			
		}
		
		pInput->NextEvent();
	}
}

void IValueMenuEntry::Render( IRender *pRender, int x, int y )
{
	const char *value = CurrentValue();
	pRender->DrawText( x, y, m_selected ? pRender->MakeColor( 255, 255, 0 ) : m_color, 16, "%s : %s ", m_label.c_str(), value ? value : "(NULL)" );
}

void IValueMenuEntry::ProcessInput( IInput *pInput )
{
	pInput->BeginRead();
	while( true )
	{
		InputEvent ev = pInput->GetEvent();
		if ( ev.m_type == InputEvent::EV_INVALID )
			break;

		if ( ev.m_type == InputEvent::EV_KEYBOARD && ev.m_keyboardEvent.m_type == KeyboardEvent::KBD_KEY_REPEAT )
		{
			if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_RIGHT )
			{
				NextValue();
				pInput->PopEvent();
				continue;
			}

			if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_LEFT )
			{
				PrevValue();
				pInput->PopEvent();
				continue;
			}			
		}
		
		pInput->NextEvent();
	}
}

void TextInputMenuEntry::Render( IRender *pRender, int x, int y )
{
	pRender->DrawText( x, y, m_selected ? pRender->MakeColor( 255, 255, 0 ) : m_color, 16, "%s : %s ", m_label.c_str(), m_value.c_str() );
}

void TextInputMenuEntry::ProcessInput( IInput *pInput )
{
	bool endEdit = false;

	pInput->BeginRead();
	while( true )
	{
		InputEvent ev = pInput->GetEvent();
		if ( ev.m_type == InputEvent::EV_INVALID )
			break;

		if ( ev.m_type == InputEvent::EV_KEYBOARD )
		{
			if ( ev.m_keyboardEvent.m_type == KeyboardEvent::KBD_KEY_REPEAT )
			{
				if ( !m_editing )
				{
					if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_ENTER )
					{
						m_editing = true;
						pInput->PopEvent();
						continue;
					}
				}
				else
				{
					if ( isprint( ev.m_keyboardEvent.m_unichar ) && ( m_maxLength < 0 || (int)m_value.length() < m_maxLength ) )
					{
						char c = ev.m_keyboardEvent.m_unichar;
						m_value.append( &c, 1 );
					}
					else
					{
						if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_BACKSPACE )
						{
							if ( !m_value.empty() )
								m_value.erase( m_value.begin() + m_value.length() - 1 );
						}
						else if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_ESCAPE && m_canCancel )
						{
							m_value = m_oldValue;
							endEdit = true;
							if ( m_pCallback )
								m_pCallback->CancelEdit();
						}
					}
				}
			}
			else if ( ev.m_keyboardEvent.m_type == KeyboardEvent::KBD_KEY_UP )
			{
				if ( ev.m_keyboardEvent.m_keycode == ALLEGRO_KEY_ENTER )
				{
					endEdit = true;
					if ( m_pCallback )
						m_pCallback->AcceptEdit( m_value );
				}
			}
		}

		if ( m_editing )
			pInput->PopEvent();
		else
			pInput->NextEvent();
	}

	if ( endEdit )
	{
		m_editing = false;
		pInput->Clear();
	}
}
