#pragma once
#include "BaseGameState.h"
#include "BitmapManager.h"
#include "TextManager.h"
#include "TextPrinter.h"

/*
	This state represents briefing screen between levels
*/
class GameStateNextLevel : public BaseGameState
{
	TextPrinter m_textPrinter;

	  // Various timers
	float m_timer;
	  // Text flash timer
	float m_flash;

	  // Currently drawing piece of briefing
	int m_briefingIndex;

	  // Buffer for drawing briefing on
	ImageHandle m_image;
	  // Icon of current speaker
	ImageHandle m_currentActor;
	  // If true, m_briefingIndex needs to be incremented
	bool m_next;
	  // If true, this is the first Update of this state after it was pushed
	  // We need to load information about briefing
	bool m_first;
	  // If true, all briefing was displayed
	bool m_finish;
	  // If true, player wishes to skip a piece of briefing
	bool m_skipPhrase;
	  // If true, player wishes to skip all briefing
	bool m_skipAll;
	  // If true, fade out is currently active
	bool m_fade;

	  // Y of current piece of briefing
	int m_areaY;
	  // Current text coordinates
	int m_textY;
	int m_textX;

	  // Background image
	ImageHandle m_bgImage;

	bool SkipPhrase( const InputEvent & e);
	bool SkipAll( const InputEvent & e);

public:
	GameStateNextLevel()
		: BaseGameState( GAMESTATE_NEXT_LEVEL )
	{
	}

	void RenderBefore( IRender & render, const IGameContext & context );
	void RenderAfter( IRender & render, const IGameContext & context );
	void Update( float dt, IGameContext & context );

	bool AllowPhysicsUpdate() const { return false; }
	bool AllowGraphicsUpdate() const { return false; }
	bool AllowGraphicsRender() const { return false; }
	bool AllowAIUpdate() const { return false; }

	void OnPush( IGameContext & context );
	void OnRemove( IGameContext & context ) {}
};
