#include "stdafx.h"
#include "GameStateMenu.h"
#include "ObjectsStorage.h"
#include "PlayerProfile.h"

void GameStateMenu::RenderBefore( IRender & render, const IGameContext & context )
{
	render.CopyRegion( m_image, 0, 0, 0, 0, -1, -1, SCREEN_W, SCREEN_H );	
	render.DrawRectFill( 0, 0, SCREEN_W, SCREEN_H, Color( 0, 0, 0, 200 ) );
}

void GameStateMenu::RenderAfter( IRender & render, const IGameContext & context )
{
	m_pMenu->Render( &render );
}

void GameStateMenu::Update( float dt, IGameContext & context )
{
	m_pMenu->Update( dt );

	if ( m_startGame )
	{
		context.GetPlayerProfile().m_hardcore = true;
		context.RestartGame();
		context.RemoveState( GAMESTATE_MENU );
		context.PushState( GAMESTATE_NEXT_LEVEL );
		m_startGame = false;
	}

	if ( m_exitGame )
	{
		context.RemoveState( GAMESTATE_MENU );
		m_exitGame = false;
	}

	if ( m_selectLevel )
	{
		m_selectLevelMenu.ReInit( context );
		m_pMenu = &m_selectLevelMenu;
		m_pMenu->OnShow();
		m_selectLevel = false;
	}

	if ( m_showOptions )
	{
		m_pMenu = &m_options;
		m_pMenu->OnShow();
		m_showOptions = false;
	}

	if ( m_showSubOptions )
	{
		switch( m_showSubOptions )
		{
			case OPTIONS_VIDEO: m_pMenu = &m_vidOptions; break;
			case OPTIONS_SOUND: m_pMenu = &m_sndOptions; break;
			case OPTIONS_CONTROLS: m_pMenu = &m_ctrlOptions; break;
			case OPTIONS_GAME: m_pMenu = &m_gameOptions; break;
		}

		m_pMenu->OnShow();
		
		m_showSubOptions = OPTIONS_NONE;
	}

	if ( m_backFromSubOptions )
	{
		m_pMenu = &m_options;
		m_pMenu->OnShow();
		m_backFromSubOptions = false;
	}

	if ( m_showScores )
	{
		context.RemoveState( GAMESTATE_MENU );
		context.PushState( GAMESTATE_SCORES );
		m_showScores = false;
	}

	if ( m_showAchs )
	{
		m_pMenu = &m_achMenu;
		m_pMenu->OnShow();
		m_achMenu.Init( context );
		m_showAchs = false;
	}

	if ( m_backFromOptions )
	{
		m_pMenu = &m_mainMenu;
		m_pMenu->OnShow();
		m_backFromOptions = false;
	}

	if ( m_backFromSelectLevel )
	{
		m_pMenu = &m_mainMenu;
		m_pMenu->OnShow();
		m_backFromSelectLevel = false;
	}

	if ( m_startLevel >= 0 )
	{
		m_pMenu = &m_mainMenu;
		m_pMenu->OnShow();
		context.GetPlayerProfile().m_hardcore = false;
		context.RestartGame( m_startLevel );
		context.RemoveState( GAMESTATE_MENU );
		context.PushState( GAMESTATE_NEXT_LEVEL );
		m_startLevel = -1;
	}

	if ( m_backFromAchs )
	{
		m_pMenu = &m_mainMenu;
		m_pMenu->OnShow();
		m_backFromAchs = false;
	}
}

void MainMenu::operator()( int id )
{
	switch( id )
	{
	case EID_EXIT:
		m_pCallback->ExitGame();
		return;
	case EID_OPTIONS:
		m_pCallback->ShowOptions();
		return;
	case EID_START:
		m_pCallback->StartGame();
		return;
	case EID_SELECT_LEVEL:
		m_pCallback->SelectLevel();
		return;
	case EID_SCORES:
		m_pCallback->ShowScores();
		return;
	case EID_ACHIEVEMENTS:
		m_pCallback->ShowAchievements();
		return;
	}
}

void GameStateMenu::OnPush( IGameContext & context )
{
	context.GetOjectsStorage().GetMusic().ReceiveEvent( "MENU" );
	m_image = GetRender().LoadImage( "Data/Sprites/title_screen.png" );
}
