#include"main.h"

#include"ball.h"
#include"block.h"
#include"droid.h"
#include"func.h"
#include"item.h"
#include"particles.h"
#include"message.h"

struct PLAYER{
float x,w;	//Pad position
int flags;	//Active powerups
struct PLAYER *next;
};

PLAYER *players;



void init_players(){
	players=new PLAYER;
	players->x=0;
	players->w=.125;
	players->flags=0;
	players->next=NULL;
}



void reset_players(){
	players->w=.125;
	players->flags=0;
}



void update_players(){
	PLAYER *player=players;
	int mx,my;
	static int num_balls;
	static bool kfp=0;
	get_mouse_mickeys(&mx,&my);
	position_mouse(SCREEN_W/2, SCREEN_H/2);

	player->x+=mx/1000.0;
	if(player->x<0)	player->x+=1;
	if(player->x>1)	player->x-=1;

	//This is just for testing the guns
//	player->flags|=BULLET;
//	player->flags|=HOLD;
	if(key[KEY_F] && !kfp && (player->flags&BULLET)){
		kfp=1;
		balls.push_back(BALL(player->x+player->w/2-.015625,.125,0,.01,BULLET));
		balls.push_back(BALL(player->x-player->w/2+.015625,.125,0,.01,BULLET));
	}
	if(!key[KEY_F] && kfp)	kfp=0;

	if(balls.empty() || !num_balls){
		reset_players();
		balls.push_back(BALL(player->x-mx/1000.0,.125,0,.0075,HOLD)); //The xpos must be set wrong here since it's updated later
	}
	num_balls=0;
	for(list<BALL>::iterator ball=balls.begin(); ball != balls.end();ball++){
		if(!(ball->flags&BULLET))	num_balls++;
		if(ball->flags&HOLD){
			if(mouse_b&1)
				ball->flags^=HOLD;
			else
				ball->x+=mx/1000.0;
		}
		if(player->flags&UNSTOPABLE)
			ball->flags|=UNSTOPABLE;
		else if(ball->flags&UNSTOPABLE)
			ball->flags^=UNSTOPABLE;

		if(ball->y<.125 && ball->y>.0625 && diff(ball->x,player->x)<player->w/2 && diff(ball->x,player->x)>-player->w/2){
			score+=1;
			msgs.push_back(MESSAGE("+1",ball->x,ball->y));
			ball->y=.125;
			double s=pyth(ball->xs,ball->ys);
			s=s<bs?s:bs;
			ball->xs+=diff(ball->x,player->x)/30;
			ball->ys*=-spdmul;
			double a=atan2 (ball->ys, ball->xs);
			ball->xs=cos(a)*s;
			ball->ys=sin(a)*s;
			if(player->flags&HOLD && mouse_b&2)
				ball->flags|=HOLD;
		}
	}

	for(list<DROID>::iterator droid=droids.begin();droid!=droids.end();droid++){
		if(droid->y<.125 && droid->y>.0625 && diff(droid->x,player->x)<player->w/2 && diff(droid->x,player->x)>-player->w/2){
			fire_particles(droid->x,droid->y,makecol(255,0,0),25);
			droid->y=-1;
		}
	}

	for(list<ITEM>::iterator item=items.begin();item!=items.end();item++){
		if(item->flags&HOLD){
			if(key[KEY_G])
				item->flags^=HOLD;
			else
				item->x+=mx/1000.0;
		}

		if(item->y<.125 && item->y>.0625 && diff(item->x,player->x)<player->w/2 && diff(item->x,player->x)>-player->w/2){
			switch(item->type){
			case 0:	//Ganja seed
				item->flags|=HOLD;
				item->y=.0625;
				item->x=player->x;
				break;
			case 1:	//Catch
				score+=5;
				msgs.push_back(MESSAGE("+5",item->x,item->y));
				player->flags|=HOLD;
				item->y=-1;
				break;
			case 2:	//Expand
				score+=20;
				msgs.push_back(MESSAGE("+20",item->x,item->y));
				item->y=-1;
				if(player->w<.25)
					player->w+=.0625;

				for(list<BALL>::iterator ball=balls.begin(); ball != balls.end();ball++)
					if(ball->flags&HOLD)
						ball->flags^=HOLD;

				break;
			case 3:	//Shrink
				score-=30;
				msgs.push_back(MESSAGE("-30",item->x,item->y));
				item->y=-1;
				if(player->w>.125)
					player->w-=.0625;

				for(list<BALL>::iterator ball=balls.begin(); ball != balls.end();ball++)
					if(ball->flags&HOLD)
						ball->flags^=HOLD;

				break;
			case 4:	//Ganja killer
				score+=50;
				msgs.push_back(MESSAGE("+50",item->x,item->y));
				item->y=-1;
				break;
			case 5:	//Unstopable balls
				score+=100;
				msgs.push_back(MESSAGE("+100",item->x,item->y));
				player->flags|=UNSTOPABLE;
				item->y=-1;
				break;
			case 6:	//Ball splitter
				score+=25;
				msgs.push_back(MESSAGE("+25",item->x,item->y));
				split_balls();
				item->y=-1;
				break;
			case 7:	//Gun mounting
				score+=70;
				msgs.push_back(MESSAGE("+70",item->x,item->y));
				player->flags|=BULLET;
				item->y=-1;
				break;
			case 8:	//Slow balls
				score+=45;
				msgs.push_back(MESSAGE("+45",item->x,item->y));
				slow_balls();
				item->y=-1;
				break;
			case 9:	//Weaken all bricks to 1
				score+=256;
				msgs.push_back(MESSAGE("+256",item->x,item->y));
				soft_blocks();
				item->y=-1;
				break;
			}
		}
	}
}



float player_pos(){
	return players->x;
}




void draw_players(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	//This bit could end up with some advanced texturizing stuff.
	//I should change the gun mounting to double gun, so I can put one on each end.
	//Have different textures for armed and unarmed pad ends
	//Diff texes for catch and no catch pad centers.
	//I need four texes, armed end, unarmed end, catching mid, nocatch mid.
	//TEX_end,TEX_aend,TEX_mid,TEX_cmid

	int color=makecol(int(r*.5),int(g*.5),int(b*.5));
	int pts=int(players->w/.03125)+1;

	float shapet[pts*2],shapeb[pts*2];
	int ishape[pts*4],ishapet[pts*4],ishapeb[pts*4];


	for(int i=0;i<pts;i++){
		shapet[i*2] = players->x+(i-pts/2)*.03125-.015625*(pts%2-1);
		shapet[i*2+1] = .125;
		shapeb[i*2] = players->x+(i-pts/2)*.03125-.015625*(pts%2-1);
		shapeb[i*2+1] = .0625;
	}

	if (project(shapet, ishapet, pts*2) && project(shapeb, ishapeb, pts*2)){
		if(textures){
			V3D_f *_vtx[4],vtx[4];
			for(int i=0;i<4;i++)
			_vtx[i]=&vtx[i];

			vtx[0].u=1;
			vtx[0].v=31;
			vtx[0].c=color;
			vtx[1].u=31;
			vtx[1].v=31;
			vtx[1].c=color;
			vtx[2].u=31;
			vtx[2].v=0;
			vtx[2].c=color;
			vtx[3].u=1;
			vtx[3].v=0;
			vtx[3].c=color;

			vtx[0].x=ishapeb[0];
			vtx[0].y=ishapeb[1];
			vtx[1].x=ishapeb[2];
			vtx[1].y=ishapeb[3];
			vtx[3].x=ishapet[0];
			vtx[3].y=ishapet[1];
			vtx[2].x=ishapet[2];
			vtx[2].y=ishapet[3];

			if(!(players->flags&BULLET))
				polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padend].dat, 4, _vtx);
			else
				polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padendg].dat, 4, _vtx);

			for(int i=1;i<pts-2;i++){
				vtx[0].x=ishapeb[i*2+0];
				vtx[0].y=ishapeb[i*2+1];
				vtx[1].x=ishapeb[i*2+2];
				vtx[1].y=ishapeb[i*2+3];
				vtx[3].x=ishapet[i*2+0];
				vtx[3].y=ishapet[i*2+1];
				vtx[2].x=ishapet[i*2+2];
				vtx[2].y=ishapet[i*2+3];
				if(!(players->flags&HOLD))
					polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padmid].dat, 4, _vtx);
				else
					polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padmidc].dat, 4, _vtx);
			}

			vtx[1].x=ishapeb[(pts-2)*2+0];
			vtx[1].y=ishapeb[(pts-2)*2+1];
			vtx[0].x=ishapeb[(pts-2)*2+2];
			vtx[0].y=ishapeb[(pts-2)*2+3];
			vtx[2].x=ishapet[(pts-2)*2+0];
			vtx[2].y=ishapet[(pts-2)*2+1];
			vtx[3].x=ishapet[(pts-2)*2+2];
			vtx[3].y=ishapet[(pts-2)*2+3];

			if(!(players->flags&BULLET))
				polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padend].dat, 4, _vtx);
			else
				polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_padendg].dat, 4, _vtx);

		}
		else{
			for(int i=0;i<pts;i++){
				ishape[i*2]=ishapet[i*2];
				ishape[i*2+1]=ishapet[i*2+1];
				ishape[pts*2+i*2]=ishapeb[pts*2-(i+1)*2];
				ishape[pts*2+i*2+1]=ishapeb[pts*2-(i+1)*2+1];
			}
			polygon(buffer, pts*2, ishape, color);
		}
	}


	if(!textures){
		float shape[pts*4];
		if(players->flags&HOLD){
			for(int i=0;i<pts;i++)
				shapeb[i*2+1] = .12;
			if (project(shapeb, ishapeb, pts*2)){
				for(int i=0;i<pts;i++){
					ishape[i*2]=ishapet[i*2];
					ishape[i*2+1]=ishapet[i*2+1];
					ishape[pts*2+i*2]=ishapeb[pts*2-(i+1)*2];
					ishape[pts*2+i*2+1]=ishapeb[pts*2-(i+1)*2+1];
				}
				polygon(buffer, pts*2, ishape, makecol(127,0,0));
			}
		}

		if(players->flags&BULLET){
			shape[1]=.125;
			shape[3]=.125;
			shape[5]=.1;
			shape[7]=.1;

			shape[0]=players->x+players->w/2-.01;
			shape[2]=players->x+players->w/2-.02;
			shape[4]=players->x+players->w/2-.02;
			shape[6]=players->x+players->w/2-.01;
			if (project(shape, ishape, 8))
				polygon(buffer, 4, ishape, makecol(255,0,0));
			shape[0]=players->x-players->w/2+.01;
			shape[2]=players->x-players->w/2+.02;
			shape[4]=players->x-players->w/2+.02;
			shape[6]=players->x-players->w/2+.01;
			if (project(shape, ishape, 8))
				polygon(buffer, 4, ishape, makecol(255,0,0));
		}
	}
}


void shutdown_players(){
	PLAYER *b;

	while (players) {
		b = players;
		players = players->next;
		delete b;
	}
}
 
