#include"particles.h"

list<PARTICLE> particles;



PARTICLE::PARTICLE(double ix,double iy,double ixs,double iys,int icolor,int ilife)
:x(ix),y(iy),xs(ixs),ys(iys),color(icolor),life(ilife){}



void fire_particles(double x,double y,int color,int n){
	for(int i=0;i<n;i++){
		particles.push_back(PARTICLE(x,y,cos(rand()%256)/100,sin(rand()%256)/100,color,100));
	}
}



bool PARTICLE::update(){
	x += xs;
	y += ys;
	xs *= .99;
	ys *= .99;
	life--;
	if(y<0 || y>1 || !life)
		return 0;
	else
		return 1;
}



void update_particles(){
	list<PARTICLE>::iterator p = particles.begin();
	for(;p!=particles.end();){
		if(p->update())
			p++;
		else
			p=particles.erase(p);
	}
}



void draw_particles(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int t=r;t=g;t=b;
	list<PARTICLE>::iterator particle=particles.begin();

	float shape[4];
	int ishape[8];

	for(;particle!=particles.end();particle++){
		shape[0] = particle->x;
		shape[1] = particle->y;

		shape[2] = particle->x-particle->xs;
		shape[3] = particle->y-particle->ys;

		if (project(shape, ishape, 4))
			line(buffer,ishape[0],ishape[1],ishape[0],ishape[1],particle->color);
	}
}
 
