#include"main.h"

#include"item.h"

struct ITEMTYPE{
	int color;
	char c;
};

list<ITEM> items;
const int num_types=10;
ITEMTYPE itemtype[num_types];



ITEM::ITEM(double ix,double iy,double ixs,double iys,int itype,int iflags)
:x(ix),y(iy),xs(ixs),ys(iys),type(itype),flags(iflags){}



void init_items(){
	itemtype[0].color=makecol(0,255,0);		//Ganja seed
	itemtype[0].c='G';
	itemtype[1].color=makecol(0,0,255);		//Catch
	itemtype[1].c='C';
	itemtype[2].color=makecol(255,255,0);		//Expand
	itemtype[2].c='E';
	itemtype[3].color=makecol(255,127,0);		//Shrink
	itemtype[3].c='R'; //"Reduce"
	itemtype[4].color=makecol(255,63,0);		//Ganja killer
	itemtype[4].c='K';
	itemtype[5].color=makecol(255,1,255);		//Unstopable
	itemtype[5].c='U';
	itemtype[6].color=makecol(100,100,100);	//Split
	itemtype[6].c='D'; //"Double"
	itemtype[7].color=makecol(225,225,225);	//Gun
	itemtype[7].c='W'; //"Weapon"
	itemtype[8].color=makecol(150,80,0);		//Slow
	itemtype[8].c='S';
	itemtype[9].color=makecol(222,222,0);		//Weak bricks
	itemtype[9].c='B';
}



void drop_item(double x,double y){
	items.push_back(ITEM(x,y,0,-.005,rand()%num_types,0));
}



void update_items(){
	list<ITEM>::iterator b;
	for(b=items.begin();b!=items.end();){
		if(!b->flags&HOLD){
			b->x += b->xs;
			b->y += b->ys;
		}

		if(b->y>1)	b->ys=-b->ys;
		if(b->x<0)	b->x+=1;
		if(b->x>1)	b->x-=1;

		if(b->y<0)
			b=items.erase(b);
		else
			b++;
	}
}



void draw_items(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int t=r;t=g;t=b;
	list<ITEM>::iterator item;
	float shape[8];
	int ishape[16];
	int x,y;


	for(item=items.begin();item!=items.end(); item++){
		shape[0] = item->x-.01;
		shape[1] = item->y+.01;
		shape[2] = item->x+.01;
		shape[3] = item->y+.01;
		shape[4] = item->x+.01;
		shape[5] = item->y-.01;
		shape[6] = item->x-.01;
		shape[7] = item->y-.01;

		if (project(shape, ishape, 8)){
			x=ishape[0]+(ishape[2]-ishape[0])/2-3;
			y=ishape[1]+(ishape[5]-ishape[1])/2-3;
//			polygon(buffer, 4, ishape, itemtype[item->type].color);
			textprintf(buffer,font,x,y,itemtype[item->type].color,"%c",itemtype[item->type].c);
		}
	}
} 
