#include<list>

#include"main.h"

#include"ball.h"
#include"droid.h"
#include"item.h"
#include"message.h"

struct GANJA{
int strength;	//How many hits can it take
};

const int num_ganjas=16;
GANJA ganja[num_ganjas];
float gs=1/double(num_ganjas);
int living_ganjas=16;



void init_ganjas(){
	for(int i=0;i<num_ganjas;i++)
		ganja[i].strength=1;
}



void plant_ganjas(){
	living_ganjas=num_ganjas;
	init_ganjas();
}



bool update_ganjas(){
	int h;

	for(list<BALL>::iterator ball=balls.begin(); ball != balls.end();ball++){
		if(ball->y<.0625 && ball->y>=0){
			h=int(ball->x*num_ganjas);
			if(ganja[h].strength){
				score-=100;
				msgs.push_back(MESSAGE("-100",ball->x,ball->y));
				ganja[h].strength--;
				ball->y=-1;
				if(!ganja[h].strength)
					living_ganjas--;
			}
		}
	}

	for(list<DROID>::iterator droid=droids.begin();droid!=droids.end();droid++){
		if(droid->y<.0625 && droid->y>=0){
			h=int(droid->x*num_ganjas);
			if(ganja[h].strength){
				score-=100;
				msgs.push_back(MESSAGE("-100",droid->x,droid->y));
				ganja[h].strength--;
				droid->y=-1;
				if(!ganja[h].strength)
					living_ganjas--;
			}
		}
	}

	for(list<ITEM>::iterator item=items.begin();item!=items.end();item++){
		if(item->y<.0625 && item->y>0){
			h=int(item->x*num_ganjas);
			if(item->type==0){	//Ganja seed
				if(ganja[h].strength<1){
					score+=30;
					msgs.push_back(MESSAGE("+30",item->x,item->y));
					ganja[h].strength++;
					if(ganja[h].strength==1)
						living_ganjas++;
				}
				item->y=-1;
			}
			else if(item->type==4){	//Ganja killer
				if(ganja[h].strength){
					score-=50;
					msgs.push_back(MESSAGE("-50",item->x,item->y));
					ganja[h].strength--;
				}
				if(!ganja[h].strength)
					living_ganjas--;
				item->y=-1;
			}
			else if(ganja[h].strength)	//To prevent the rest from ghosting through
				item->y=-1;
		}
	}

	if(!living_ganjas)	return true;
	return false;
}



void draw_ganjas(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int color=makecol(r,g,b);
	float shape[8];
	int ishape[16];

	V3D_f *vtx[4],_vtx[4];
	for(int i=0;i<4;i++)
		vtx[i]=&_vtx[i];

	_vtx[0].u=0;
	_vtx[0].v=32;
	_vtx[0].c=color;
	_vtx[1].u=32;
	_vtx[1].v=32;
	_vtx[1].c=color;
	_vtx[2].u=32;
	_vtx[2].v=0;
	_vtx[2].c=color;
	_vtx[3].u=0;
	_vtx[3].v=0;
	_vtx[3].c=color;

	int duoble;
	int *dishape;

	for(int n=0;n<num_ganjas;n++){
		if(ganja[n].strength || textures){
			shape[0] = n*gs;
			shape[1] = 0;
			shape[2] = n*gs+gs;
			shape[3] = 0;
			shape[4] = n*gs+gs;
			shape[5] = .0625;
			shape[6] = n*gs;
			shape[7] = .0625;

			duoble=project(shape, ishape, 8);
			dishape=ishape;
			for(int i=0;i<duoble;i++){
				if(textures){
					_vtx[0].x=dishape[0];
					_vtx[0].y=dishape[1];
					_vtx[1].x=dishape[2];
					_vtx[1].y=dishape[3];
					_vtx[2].x=dishape[4];
					_vtx[2].y=dishape[5];
					_vtx[3].x=dishape[6];
					_vtx[3].y=dishape[7];
					if(ganja[n].strength)
						polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_ganja].dat, 4, vtx);
					else
						polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_ganjan].dat, 4, vtx);
				}
				else{
					if(ganja[n].strength)
						polygon(buffer, 4, dishape, makecol(int(r/5.0),int(g/5.0),int(b/5.0)));
				}
				dishape+=8;
			}
		}
	}
}
 
