#include<list>

#include"main.h"

#include"ball.h"
#include"block.h"
#include"droid.h"
#include"func.h"
#include"particles.h"

list<DROID> droids;


DROID::DROID(float ix,float iy,float ixs,float iys)
:x(ix),y(iy),xs(ixs),ys(iys){}



bool DROID::update(){
	float s;
	int a;

	for(list<BALL>::iterator ball=balls.begin(); ball != balls.end();ball++){
		if(pyth(ball->x-x,ball->y-y)<.02){	//This ball crashed into me, argh.
			fire_particles(ball->x,ball->y,makecol(255,0,0),25);
			if(!(ball->flags&UNSTOPABLE)){
				if(ball->flags&BULLET)
					ball->y=2;	//Don't bother erasing, will be done fast enough in the balls update.
				else{
					s=pyth(ball->xs,ball->ys);
					a=rand()%256;
					ball->xs=cos(a)*s;
					ball->ys=sin(a)*s;
				}
			}
			return 0;
		}
	}

	x += xs;
	y += ys;

	if(y>1){	//Let droids bounce off the playfield upper limit.
		ys=-ys;
		y=1;
	}

	//Make sure the droids stay on the playfield, by wrapping.
	if(x<0)	x+=1;
	if(x>1)	x-=1;

	//The same theory as in ball-block collision.
	for(list<BLOCK>::iterator block=blocks.begin();block!=blocks.end();block++){
		if( block->contains( x , y-ys ) ){
			fire_particles(x,y,block->color,5);
			x-=xs;
			xs=-xs;
			break;
		}
	}
	for(list<BLOCK>::iterator block=blocks.begin();block!=blocks.end();block++){
		if( block->contains( x , y ) ){
			fire_particles(x,y,block->color,5);
			y-=ys;
			ys=-ys;
			xs+=.0005*(rand()%3-1);
			break;
		}
	}

	if(y<0)
		return 0;
	else
		return 1;
}



void update_droids(){
	for(list<DROID>::iterator b=droids.begin();b!=droids.end();)
		if(b->update())
			b++;
		else
			b=droids.erase(b);
}



void DROID::draw(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int color=makecol(int(r*.5),int(g*.5),int(b*.5));
	float shape[8];
	int ishape[16];
	shape[0] = x-.01;
	shape[1] = y-.01;
	shape[2] = x+.01;
	shape[3] = y-.01;
	shape[4] = x+.01;
	shape[5] = y+.01;
	shape[6] = x-.01;
	shape[7] = y+.01;

	int duoble=project(shape, ishape, 8);
	int *dishape=ishape;

	V3D_f *_vtx[4],vtx[4];

	if (duoble){
		if(textures){
			for(int i=0;i<4;i++)
				_vtx[i]=&vtx[i];
			vtx[0].u=0;
			vtx[0].v=32;
			vtx[1].u=32;
			vtx[1].v=32;
			vtx[2].u=32;
			vtx[2].v=0;
			vtx[3].u=0;
			vtx[3].v=0;
		}
		for(int i=0;i<duoble;i++){
			if(textures){
				vtx[0].x=dishape[0];
				vtx[0].y=dishape[1];
				vtx[1].x=dishape[2];
				vtx[1].y=dishape[3];
				vtx[2].x=dishape[4];
				vtx[2].y=dishape[5];
				vtx[3].x=dishape[6];
				vtx[3].y=dishape[7];
				polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_droid].dat, 4, _vtx);
			}
			else
				polygon(buffer,4,dishape,color);
			dishape+=8;
		}
	}
}



void draw_droids(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	for(list<DROID>::iterator droid=droids.begin();droid!=droids.end();droid++)
		droid->draw(buffer,r,g,b,project);
}
 
