#include<list>
#include<allegro.h>

#include"main.h"

#include"ball.h"
#include"block.h"
#include"func.h"
#include"particles.h"
#include"message.h"

//Initiate the extern ballist
list<BALL> balls;



//The making of a new ball
BALL::BALL(float ix,float iy,float ixs,float iys,int iflags)
:x(ix),y(iy),xs(ixs),ys(iys),flags(iflags){}



//Updating the ball
bool BALL::update(){
	if(!(flags&HOLD)){	//Only move the ball if it's not held.
		x+=xs;
		y+=ys;
	}

	//First go through the blocks until x-wise collision is detected. At wich you do collision and break loop.
	list<BLOCK>::iterator block;
	for( block=blocks.begin() ; block != blocks.end() ; block++ ){
		//If in the block.
		if( block->contains( x , y-ys ) ){
			if( block->strength!=-1 ){
				score += 10;
				msgs.push_back( MESSAGE( "+10" , x , y ) );
			}
			if( flags&UNSTOPABLE ){
				fire_particles( block->x+bs/2 , block->y-bs/2 , block->color , block->strength*10 );
				blocks.erase( block );
				break;
			}
			else{
				fire_particles( block->x+bs/2 , block->y-bs/2 , block->color , 10);
				if( block->strength > 0)
					block->strength --;
				if(block->strength==-2)
					block->strength=1;
				x-=xs;
				xs*=-spdmul;
				break;
			}
		}
	}
	//Then go through y-wise collision the same way
	for(block=blocks.begin(); block != blocks.end();block++){
		if( block->contains( x , y ) ){
			if( block->strength!=-1 ){
				score += 10;
				msgs.push_back( MESSAGE( "+10" , x , y ) );
			}
			if(flags&UNSTOPABLE){
				fire_particles(block->x+bs/2,block->y-bs/2,block->color,block->strength*10);
				blocks.erase(block);
				break;
			}
			else if(flags&BULLET){
				fire_particles(block->x+bs/2,block->y-bs/2,block->color,10);
				if(block->strength>0)
					block->strength--;
				if(block->strength==-2)
					block->strength=1;
				return false;
			}
			else{
				fire_particles(block->x+bs/2,block->y-bs/2,block->color,10);
				if(block->strength>0)
					block->strength--;
				if(block->strength==-2)
					block->strength=1;
				y-=ys;
				ys*=-spdmul;
			}
		}
	}

	//Limit max speed
	if( pyth(xs,ys) > .05 ){
		ys=sin( atan2(ys,xs) )*.05;
		xs=cos( atan2(ys,xs) )*.05;
	}

	//Let balls bounce off the playfield upper limit, but not bullets.
	if( y>1 ){
		if( flags&BULLET ){
			return false;
		}
		else{
			ys=-ys;
			y=1;
		}
	}

	//Make sure the balls stay on the playfield, by wrapping.
	if(x<0)	x+=1;
	if(x>1)	x-=1;

	//Return false if the ball is out of play
	if( y<0 ) {
		score -= 25;
		msgs.push_back( MESSAGE( "-25" , x , .03125 ) );
		return false;
	}
	else
		return true;
}



void BALL::draw(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int color=makecol(r,g,b);
	float shape[8];
	int ishape[16];

	if(textures){
		V3D_f *_vtx[4],vtx[4];
		for(int i=0;i<4;i++)
			_vtx[i]=&vtx[i];

		vtx[0].u=0;
		vtx[0].v=32;
		vtx[1].u=32;
		vtx[1].v=32;
		vtx[2].u=32;
		vtx[2].v=0;
		vtx[3].u=0;
		vtx[3].v=0;

		shape[1] = y-.0075;
		shape[3] = y-.0075;
		shape[5] = y+.0075;
		shape[7] = y+.0075;

		if( flags&BULLET ){
			shape[0] = x-.0025;
			shape[2] = x+.0025;
			shape[4] = x+.0025;
			shape[6] = x-.0025;
		}
		else{
			shape[0] = x-.0075;
			shape[2] = x+.0075;
			shape[4] = x+.0075;
			shape[6] = x-.0075;
		}

		int duoble=project(shape, ishape, 8);
		int *fishape=ishape;
		for(int i=0;i<duoble;i++){
			vtx[0].x=fishape[0];
			vtx[0].y=fishape[1];
			vtx[1].x=fishape[2];
			vtx[1].y=fishape[3];
			vtx[2].x=fishape[4];
			vtx[2].y=fishape[5];
			vtx[3].x=fishape[6];
			vtx[3].y=fishape[7];

			polygon3d_f(buffer, POLYTYPE_ATEX_MASK, (BITMAP*)gfx[TEX_ball].dat, 4, _vtx);

			fishape+=8;
		}
	}
	else{
		if(flags&BULLET){
			shape[0]=x;
			shape[1]=y;
			shape[2]=x;
			shape[3]=y-.01;

			if (project(shape, ishape, 4))
				line(buffer,ishape[0],ishape[1],ishape[2],ishape[3],color);
		}
		else{
			shape[0]=x;
			shape[1]=y;

			int duoble=project(shape, ishape, 2);
			int *fishape=ishape;
			for(int i=0;i<duoble;i++){
				circlefill(buffer,fishape[0],fishape[1],2,color);
				fishape+=2;
			}
		}
	}
}



//Go through all balls and create copies with inverse xspeed.
void split_balls(){
	for(list<BALL>::iterator pos=balls.begin(); pos != balls.end();pos++)
		balls.push_front(BALL(pos->x,pos->y,-pos->xs,pos->ys,pos->flags));
}



//Half the speed of all balls.
void slow_balls(){
	float s;
	for(list<BALL>::iterator ball = balls.begin(); ball != balls.end();ball++){
		s=pyth(ball->xs,ball->ys);
		if(s>=.01){
			ball->ys/=2;
			ball->xs/=2;
		}
		else{
			ball->ys=sin( atan2(ball->ys,ball->xs) )*.005;
			ball->xs=cos( atan2(ball->ys,ball->xs) )*.005;
		}
	}
}



void draw_balls(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	for(list<BALL>::iterator pos = balls.begin(); pos != balls.end();pos++)
		pos->draw(buffer,r,g,b,project);
}



void update_balls(){
	for(list<BALL>::iterator pos = balls.begin(); pos != balls.end();){
		if(!pos->update())
			pos=balls.erase(pos);
		else pos++;
	}
} 
