#include "includes.h"
using namespace std;

/**************GLOBALS*****************/

volatile long int speed = 0;
int delay = 20;
int *ptr_delay = &delay;
int points = 0;
int difficulty = 1;
int stop = 0; int *ptr=&stop;

int pa_rockets_number; 
int pa_bullets_number;
int pa_blasts_number;

int pa_rockets_show;
int pa_bullets_show;
int pa_blasts_show;

BITMAP *buf;

/*********TIMER(not working)****************/

void inc_speed(){speed++;}END_OF_FUNCTION(inc_speed);
LOCK_VARIABLE(speed);
LOCK_FUNCTION(inc_speed); 

/****************************CLASSES************************************/

class Object{
      protected:
                int x,y;
                BITMAP *picture;
      public:         
                int return_x(){return x;}
                int return_y(){return y;}
                void set_picture(BITMAP *b){picture=b;}
                void set_position(int a1,int a2){x = a1; y = a2;}
                BITMAP* return_picture(){return picture;}
};


class Fighter : public  Object{
      private:
             bool launch_rocket;
             bool launch_bullet;
             bool launch_blast;
             int reload;
             int reload2;
             int reload3;
             int health;
             int progress;
              
      public:
             int explosion;
             Fighter(int a1,int a2){
                         x = a1; y = a2; launch_rocket = false; launch_bullet = false; launch_blast = false; reload = 15; reload2 = 3; reload3 = 60;
                         if (difficulty==1){health = 150;}
                         if (difficulty==2){health = 100;}
                         if (difficulty==3){health = 50;}
                         points = 0; progress = 0; explosion = 0;
             }
             void move(){
                 if (health > 0){ 
                  if (key[KEY_LEFT]){x=x-5;}
                  if (key[KEY_RIGHT]){x=x+5;}
                  if (key[KEY_UP]){y=y-5;}
                  if (key[KEY_DOWN]){y=y+5;}
                  if (x<10){x=x+5;}
                  if (x>580){x=x-5;}
                  if (y<30){y=y+5;}
                  if (y>420){y=y-5;}
                  progress=progress+1;
                 }                  
             }
             void shoot_rocket(){
               int *p = &pa_rockets_show;   
               if (health > 0){    
                if (pa_rockets_number>0){          
                  if (reload==15){}else{launch_rocket = false; reload++;} 
                  if ((key[KEY_A]) && (reload==15)){
                       reload = 0;
                       launch_rocket = true;
                       (*p)--;
                       if ((*p)<0) {(*p)=0;}
                  }
                }
               }       
             }
             
             void shoot_bullet(){
               int *p = &pa_bullets_show;   
               if (health > 0){    
                if (pa_bullets_number>0){          
                  if (reload2==3){}else{launch_bullet = false; reload2++;} 
                  if ((key[KEY_S]) && (reload2==3)){
                       reload2 = 0;
                       launch_bullet = true;
                       (*p)--;
                       if ((*p)<0) {(*p)=0;}
                 }
                }
               }       
             }
             
             void shoot_blast(){
               int *p = &pa_blasts_show;   
               if (health > 0){    
                if (pa_blasts_number>0){          
                  if (reload3==60){}else{launch_blast = false; reload3++;} 
                  if ((key[KEY_D]) && (reload3==60)){
                       reload3 = 0;
                       launch_blast = true;
                       (*p)--;
                       if ((*p)<0) {(*p)=0;}
                 }
                }
               }       
             }
             
             void modify_health(int a1){health = health + a1; if (health<=0) health=0;}
             
             bool fighter_destroyed(){if (health<=0){return true;}else{return false;}}
             bool return_launch_rocket(){return launch_rocket;}
             bool return_launch_bullet(){return launch_bullet;}
             bool return_launch_blast(){return launch_blast;}
             
             int return_x_center(){return (x+41);}
             int return_y_center(){return (y+31);}
             int return_health(){return health;}
             int return_progress(){return progress;}
                                    
};
 
class Enemy : public Object{
      private: 
             int health;
             int move_phase;
             int reload;   
      public:
             int explosion;
             bool fighter_destroyed(){if (health<=0){return true;}else{return false;}}
             bool flown_away(){if (y>520){return true;}else{return false;}}
             
             void init(int h){health = h; explosion = 0; move_phase = rand()%80;reload=rand()%10;}
              
             void move(int a1){
                  if ( (health>0)&&(fighter_destroyed()==false)&&(flown_away()==false)) y=y+a1;
                  reload++;
                  if (reload == 20 - difficulty){reload = 0;} 
             }
             void move_2(int a1,int a2){
                  if ( (health>0)&&(fighter_destroyed()==false)&&(flown_away()==false) ){
                       y=y+a1;
                       if ( (move_phase>=0)&&(move_phase < 40)){x=x+a2;}
                       if ( (move_phase>40)&&(move_phase < 80)){x=x-a2;}
                       move_phase++;
                       if (move_phase == 80){ move_phase=0;} 
                       reload++;
                       if (reload == 20 - difficulty){reload = 0;}                  
                  }      
             }
             
             
             void move_3(int a1,int a2){
                  if (y<100){
                     y = y + a1;
                  }else{
                     if ( (move_phase >= 0) && (move_phase< 30) ){
                          if ( (x>10) && (x<540)) {x = x + a2;}
                          if  (x<10)  {x = x + 1;}
                          if  (x>540)  {x = x - 1;}
                          if (move_phase < 15) {y = y + 3 *a1;}
                     }
                     if ( (move_phase >= 30) && (move_phase< 60) ){
                          if ( (x>10) && (x<540)) {x = x - a2;}
                          if  (x<10)  {x = x + 1;}
                          if  (x>540)  {x = x - 1;}
                          if (move_phase < 45) {y = y + 3 *a1;}
                     }
                     if ( (move_phase >= 60) && (move_phase< 80) ){
                          if  (x<10)  {x = x + 1;}
                          if  (x>540)  {x = x - 1;}
                     }
                     move_phase++;
                     if (move_phase>80){move_phase = 0;}        
                  }              
             }                     
                             
             void modify_health(int a1){health = health + a1;}
                          
             int return_x_center(){return (x+41);}
             int return_y_center(){return (y+31);}
             int return_health(){return health;}
             int return_move_phase(){return move_phase;}
             int return_reload(){return reload;}           
};

class Rocket : public Object{
      protected:
             int number;
             int status;
             int phase;
              
      public:
             bool destroyed;
             int explosion;
             int return_phase(){return phase;} 
             int return_number(){return number;}
             int return_status(){return status;}
             int return_x_center(){return (x+19);}
             int return_y_center(){return (y+17);}
              
             void set_rocket_position(int a1,int a2){x = a1; y = a2;}
             void pa_move(){
                  if (status==1){if (phase<60){y=y-8; phase++;}}
             }
             void enemy_move(Fighter *f){
                  if (status==1){
                     y=y+4;
                     if (return_x_center()-(f->return_x_center())<0){x++;}
                     if (return_x_center()-(f->return_x_center())>0){x--;}
                  }    
             }
             void set_status(int a1){status= a1;}
             void set_phase(int a1){phase = a1;}
             
};

class Bullet : public Object{
      protected:
             int number;
             int status;
             int phase; 
      public:
             int return_phase(){return phase;} 
             int return_number(){return number;}
             int return_status(){return status;}
             int return_x_center(){return (x+2);}
             int return_y_center(){return (y+2);}
             
              
             void pa_move(){
                  if (status==1){if (phase<60){y=y-8; phase++;}}
             }
                  
             void set_status(int a1){status= a1;}
             void set_phase(int a1){phase = a1;}
};

class Sonic_blast{
      protected:
             int y;   
             int status;
             int phase;       
      public:
             int return_y(){return y;}
             int return_status(){return status;}
             int return_phase(){return phase;}
             
             void set_position(int a1){y=a1;}
             void pa_move(){
                  if (status==1){if (phase<25) {y=y-5; phase++;}}
             }
             void set_status(int a1){status = a1;}
             void set_phase(int a1){phase = a1;}               
};      
       
class Player{
      private:
            int overall;    
            int score_array[3];
            string name;
      public: 
            int number;      
            void init_scores(){
                 for (int i = 0; i < 2; i++){score_array[i] = 0;}    
            }
            void set_name(string s){
                 name = s;                     
            }
            void fill_scores(int n1,int n2){
                 score_array[n1] = n2;
            }
            void set_overall(int a){overall = a;}
            int return_overall_p(){
                overall = score_array[0] + score_array[1];
                return overall;
            }
            int return_overall(){return overall;}     
            int* return_scores(){return score_array;}
            string return_name(){return name;}         
};

struct Wave {
       int start;
       BITMAP* b[4];
       int x;
       int y;
       int phase;
};             
      
                   
/************************Declarations********************************/
void init();
void deinit();
void set_pa_rockets(Rocket r[],BITMAP *b);
int check_pa_rocket(Rocket r[],Fighter *f);
void move_pa_rocket(Rocket r[]);
void move_pa_rocket(Rocket r[]);
void destroy_pa_rocket(Rocket r[]);
void rocket_hit(Rocket r[],Enemy e[],int num);
void set_pa_bullets(Bullet bl[],BITMAP *b);
int check_pa_bullet(Bullet b[],Fighter *f);
void move_pa_bullet(Bullet b[]);
void destroy_pa_bullet(Bullet b[]);
void bullet_hit(Bullet b[],Enemy e[],int num);
void set_pa_blasts(Sonic_blast s[]);
int check_pa_blast(Sonic_blast s[],Fighter *f);
void move_pa_blasts(Sonic_blast s[]);
void destroy_pa_blast(Sonic_blast s[]);
void blast_hit(Sonic_blast s[],Enemy e[],int num);
void set_enemy_rockets(Rocket r[],BITMAP *b,int num);
int check_enemy_rocket(Rocket r[],Enemy e[],int fr,int *p1,int *p2,int num,int num2,int h);
void move_enemy_rocket(Rocket r[],Fighter *f,int num);
void destroy_enemy_rocket(Rocket r[],int num);
void rocket_hit(Rocket r[],Fighter *f,int num);
void set_enemy_fighters(Enemy e[], BITMAP *b,int num,int h);
void weapon_collisions(Rocket r[],Rocket r2[],Bullet b[],Sonic_blast s[],int num1);
void vehicles_collisions(Enemy e[],Fighter *f,int num1);
void display_small_explosion(Rocket r2[],BITMAP *b1,BITMAP *b2,BITMAP *bb,int number);
void display_fighter_explosion(Fighter *f,BITMAP *b1,BITMAP *b2,BITMAP *bb);
void display_explosion(Enemy e[],BITMAP *b1, BITMAP *b2,BITMAP *bb,int num);
void display_ground(BITMAP *b1,BITMAP *bb,int n,int ar_x[],int ar_y[]);
void display_forests(BITMAP *b1, BITMAP *b2,BITMAP *bb);
void display_airport(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb);
void display_road(BITMAP *b1,BITMAP *bb);
void display_cars(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb);
void display_buildings(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb);
void display_fighter_info(BITMAP *bb,Fighter *f);
void display_level_1(Fighter *f,Enemy e[],Enemy e2[],Enemy e3[],Rocket r[], Rocket r2[], Rocket r3[],Bullet b[],Sonic_blast s[],BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *b4,BITMAP *b5,BITMAP *b6,BITMAP *b7,BITMAP *b8,BITMAP *b9,BITMAP *b10,BITMAP *b11,BITMAP *b12,BITMAP *b13,BITMAP *b14,BITMAP *b15,BITMAP *b16,BITMAP *b17,BITMAP *b18,BITMAP *bb,int ar_x[],int ar_y[],int pa_rockets_number,int enemy_rockets_number,int enemy_rockets_number2,int num,int num2,int num3);
void clear_disp();
void select_player(Player &p);
void set_name(Player &p);
void view_help();
void set_difficulty();
void stats(Player &p);
void start_game(Player &p,int *ptr);
bool end_level_death(int *p,Fighter *f);
void menu(Player &p,int *ptr,Player best[]);
void start_level_1(Player &pp,int *ptr);
Player load_player(char c[]);
void save_player(Player &p);
void load_best(Player best[]);
void update_best(Player best[],Player &p);
void show_high_scores(Player best[]);
void end_lev_stats(Player &p,Fighter *f,int a1);
int pause();
void delete_current_player(Player &p);
void game_options(int *ptr);
void start_level_2(Player &pp,int *ptr);
void display_isles(BITMAP *bb, BITMAP *b[]);
void display_level_2(Fighter *f,Enemy e[],Enemy e2[],Enemy e3[],Enemy e4[],Enemy e5[],Enemy e6[],Rocket r[],Rocket r2[],Rocket r3[],Rocket r4[],Bullet bl[],Sonic_blast s[],Wave waves[],BITMAP *b[],BITMAP *bb,int n1,int n2,int n3,int n4,int n5,int n6,int m,int m2,int m3, int m4 ,int m5 ,int m6);
void credits();
void end_game(Fighter *f);
 

/*************************FUNCTIONS**********************************/
         
//////Rockets////

void set_pa_rockets(Rocket r[],BITMAP *b){
     for (int i = 0; i < pa_rockets_number; i++){
         r[i].set_phase(0);
         r[i].set_status(0);
         r[i].set_picture(b);
         r[i].destroyed=false;
         r[i].explosion=0;
         //r[i].set_rocket_position(100,100);
     }    
}     

     
int check_pa_rocket(Rocket r[],Fighter *f){
    int i  = 0;
    if (f->return_launch_rocket()==true){
      for (i = 0; i < pa_rockets_number; i++){
          if (r[i].return_status()==1) { break;}
      }
      i--;
      if (i>=0){
         r[i].set_rocket_position((f->return_x())+18,f->return_y());
         r[i].set_status(1);
      }   
    }
    return i;           
}             
    
void move_pa_rocket(Rocket r[]){
    int i;
    for (i=0;i<pa_rockets_number;i++){
        if (r[i].return_status()==1){r[i].pa_move();}
    }      
}

void destroy_pa_rocket(Rocket r[]){
     for (int i = 0; i < pa_rockets_number; i++){
         if ( (r[i].return_status()==1) && (r[i].return_phase()==60) ){ r[i].set_rocket_position(-100,3000);}
     }    
}
 
    

void rocket_hit(Rocket r[],Enemy e[],int num){
     for (int i = 0; i < pa_rockets_number; i++){
       for(int j = 0; j < num; j++){  
         if (  ( abs(r[i].return_x_center()-(e[j].return_x_center()) ) < 41 ) &&  ( abs(r[i].return_y_center()-(e[j].return_y_center()) ) < 32 ) && (r[i].destroyed==false) ){
               e[j].modify_health(-50);
               r[i].destroyed = true;
         }
       }        
     }        
}

  


//////Bulltets///////
void set_pa_bullets(Bullet bl[],BITMAP *b){
     for (int i = 0; i < pa_bullets_number; i++){
         bl[i].set_phase(0);
         bl[i].set_status(0);
         bl[i].set_picture(b);
         
     }    
}     


int check_pa_bullet(Bullet b[],Fighter *f){
    int i  = 0;
    if (f->return_launch_bullet()==true){
      for (i = 0; i < pa_bullets_number; i++){
          if (b[i].return_status()==1) { break;}
      }
      i--;
      if (i>=0){
         b[i].set_position((f->return_x())+35,f->return_y());
         b[i].set_status(1);
      }   
    }
    return i;           
}

void move_pa_bullet(Bullet b[]){
    int i;
    for (i=0;i<pa_bullets_number;i++){
        if (b[i].return_status()==1){b[i].pa_move();}
    }      
}

void destroy_pa_bullet(Bullet b[]){
     for (int i = 0; i < pa_bullets_number; i++){
         if ( (b[i].return_status()==1) && (b[i].return_phase()==60) ){ b[i].set_position(-100,-100);}
     }    
}

void bullet_hit(Bullet b[],Enemy e[],int num){
     for (int i = 0; i < pa_bullets_number; i++){
       for(int j = 0; j < num; j++){  
         if (  ( abs(b[i].return_x_center()-(e[j].return_x_center()) ) < 41 ) &&  ( abs(b[i].return_y_center()-(e[j].return_y_center()) ) < 32 ) ){
               e[j].modify_health(-5);
               b[i].set_position(-100,3000);
         }
       }        
     }        
}
/////sonic blasts
void set_pa_blasts(Sonic_blast s[]){
     for (int i = 0; i < pa_blasts_number; i++){
         s[i].set_phase(0);
         s[i].set_status(0);
     }    
}     


int check_pa_blast(Sonic_blast s[],Fighter *f){
    int i  = 0;
    if (f->return_launch_blast()==true){
      for (i = 0; i < pa_blasts_number; i++){
          if (s[i].return_status()==1) { break;}
      }
      i--;
      if (i>=0){
         s[i].set_position(f->return_y_center());
         s[i].set_status(1);
      }   
    }
    return i;           
}

void move_pa_blasts(Sonic_blast s[]){
    int i;
    for (i=0;i<pa_blasts_number;i++){
        if (s[i].return_status()==1){s[i].pa_move();}
    }      
}

void destroy_pa_blast(Sonic_blast s[]){
     for (int i = 0; i < pa_blasts_number; i++){
         if ( (s[i].return_status()==1) && (s[i].return_phase()==25) ){ s[i].set_position(1000);}
     }    
}

void blast_hit(Sonic_blast s[],Enemy e[],int num){
     for (int i = 0; i < pa_blasts_number; i++){
       for(int j = 0; j < num; j++){  
         if ( (abs(s[i].return_y() - e[j].return_y_center())<6) && (s[i].return_status()==1) ){
               e[j].modify_health(-40);
         }
       }        
     }        
}
/////

    
                    
//////////////////////////////


////Enemy_rockets/////

void set_enemy_rockets(Rocket r[],BITMAP *b,int num){
     for (int i = 0; i < num; i++){
         r[i].set_phase(0);
         r[i].set_status(0);
         r[i].explosion = 0;
         r[i].destroyed = false;
         r[i].set_picture(b);
         //r[i].set_rocket_position(100,100);
     }    
}     

   
int check_enemy_rocket(Rocket r[],Enemy e[],int fr,int *p1,int *p2,int num,int num2,int h){
    //static int j = 0;
    //static int reload = 0;
    int i;
    if (*p1 % fr == 0){        
       for (i = 0; i < num2; i++){
          if (r[i].return_status()==1) { break;}
       }
       i--;
       r[i].set_rocket_position((e[*p2].return_x())+18,e[*p2].return_y());
       r[i].set_status(1);
       (*p1)++;           
    }else{
       (*p2)=rand()%num;
       for (int i = 0; i < h; i++){if ((e[*p2].return_y()>470) && (e[*p2].return_y()<0)){(*p2)=rand()%num;}else{break;}}
       (*p1)++;                   
    }
    if (*p2 == num){*p2 = 0;}                  
    
    return i;           
}             
     
void move_enemy_rocket(Rocket r[],Fighter *f,int num){
    int i;
    for (i=0;i<num;i++){
        if (r[i].return_status()==1){r[i].enemy_move(f);}
    }      
}

void destroy_enemy_rocket(Rocket r[],int num){
     for (int i = 0; i < num; i++){
         if ( (r[i].return_status()==1) && (r[i].return_phase()==60) ){ r[i].set_rocket_position(-300,-300);}
         if ( (r[i].return_x_center()<0) || ( r[i].return_x_center()>640) || ( r[i].return_y_center()>480) || ( r[i].return_y_center()<-500)  ){ r[i].set_rocket_position(-300,-300);}
     }    
}

    

void rocket_hit(Rocket r[],Fighter *f,int num){
     for (int i = 0; i < num; i++){
         
         if (  ( abs(r[i].return_x_center()-(f->return_x_center()) ) < 41 ) &&  ( abs(r[i].return_y_center()-(f->return_y_center()) ) < 32 ) && (r[i].destroyed==false) && (r[i].return_status()==1) ){
               f->modify_health(-25);
               r[i].destroyed=true;
         }
               
     }        
}
///
void set_enemy_fighters(Enemy e[], BITMAP *b,int num,int h){
     for (int i = 0; i < num; i++){
         e[i].init(h);
         e[i].set_picture(b);
     }    
}


///Collisions
void weapon_collisions(Rocket r[],Rocket r2[],Bullet b[],Sonic_blast s[],int num1){
     for (int i = 0; i < pa_rockets_number; i++){
         for (int j = 0; j < num1;j++){
             if ( ( abs(r[i].return_x_center() - r2[j].return_x_center())<8) && ( abs(r[i].return_y_center() - r2[j].return_y_center())<8) && (r[i].return_status()==1) ){
                  r[i].set_position(-200,-200);                  
                  r2[j].destroyed = true;
             }               
         }    
     }
     for (int i = 0; i < pa_bullets_number; i++){
         for (int j = 0; j < num1;j++){
             if ( ( abs(b[i].return_x_center() - r2[j].return_x_center())<8) && ( abs(b[i].return_y_center() - r2[j].return_y_center())<8) && (b[i].return_status()==1) ){
                  b[i].set_position(-200,-200);
                  r2[j].destroyed = true;
             }               
         }    
     }
     for (int i = 0; i < pa_blasts_number; i++){
         for (int j = 0; j < num1;j++){
             if ( ( abs( s[i].return_y() - r2[j].return_y_center() )<10 ) && (s[i].return_status()==1) ){
                  b[i].set_position(-200,-200);
                  r2[j].destroyed = true;
             }               
         }    
     }             
}

void vehicles_collisions(Enemy e[],Fighter *f,int num1){
     for (int i = 0; i < num1; i++){
         if ( ( abs( f->return_x_center() - e[i].return_x_center()) < 30) && (abs( f->return_y_center() - e[i].return_y_center()) < 30)){
              e[i].modify_health(-200);
              f->modify_health(-200);
         }     
     }        
}          
///




///Displaying(not only, especially when it comes to "explosions functions")
void display_small_explosion(Rocket r2[],BITMAP *b1,BITMAP *b2,BITMAP *bb,int number){
    for  (int i = 0; i < number; i++){
         if ( (r2[i].destroyed == true) && (r2[i].explosion<3)){
            masked_blit(b1,bb,0,0,(r2[i].return_x()),(r2[i].return_y()),b1->w,b1->h);                 
            r2[i].explosion++;                    
         }
         if ( (r2[i].destroyed == true) && (r2[i].explosion<6)){
            masked_blit(b2,bb,0,0,(r2[i].return_x()),(r2[i].return_y()),b2->w,b2->h);                 
            r2[i].explosion++;                    
         } 
         if ( (r2[i].destroyed == true) && (r2[i].explosion<9)){
            masked_blit(b1,bb,0,0,(r2[i].return_x()),(r2[i].return_y()),b1->w,b1->h);                 
            r2[i].explosion++;                    
         }
         if ( (r2[i].destroyed == true) && (r2[i].explosion>=9)){r2[i].set_position(-200,-200);}                                   
    }               
}     

void display_fighter_explosion(Fighter *f,BITMAP *b1,BITMAP *b2,BITMAP *bb){
     if ( (f->fighter_destroyed()==true) && (f->explosion<3)){
            masked_blit(b1,bb,0,0,(f->return_x()),(f->return_y()),b1->w,b1->h);
            (f->explosion)++;     
     }
     if ( (f->fighter_destroyed()==true) && (f->explosion<6)){
            masked_blit(b1,bb,0,0,(f->return_x()),(f->return_y()),b1->w,b1->h);
            (f->explosion)++;     
     }
     if ( (f->fighter_destroyed()==true) && (f->explosion<9)){
            masked_blit(b1,bb,0,0,(f->return_x()),(f->return_y()),b1->w,b1->h);
            (f->explosion)++;     
     }
     if ( (f->fighter_destroyed()==true) && (f->explosion<12)){
            masked_blit(b1,bb,0,0,(f->return_x()),(f->return_y()),b1->w,b1->h);
            (f->explosion)++;     
     }
     if ( (f->fighter_destroyed()==true) && (f->explosion>=12)){f->set_position(1000,-1100);}         
}    


void display_explosion(Enemy e[],BITMAP *b1, BITMAP *b2,BITMAP *bb,int num){
     for (int i = 0; i < num; i++){
         if ( (e[i].fighter_destroyed()==true) && (e[i].explosion<3)){
            masked_blit(b1,bb,0,0,(e[i].return_x()),(e[i].return_y()),b1->w,b1->h);
            e[i].explosion++;     
         }
         if ( e[i].explosion==3) {points++;}
         if ( (e[i].fighter_destroyed()==true) && (e[i].explosion<6)){
            masked_blit(b2,bb,0,0,(e[i].return_x()),(e[i].return_y()),b2->w,b2->h);
            e[i].explosion++;   
         }
         if ( (e[i].fighter_destroyed()==true) && (e[i].explosion<9)){
            masked_blit(b2,bb,0,0,(e[i].return_x()),(e[i].return_y()),b2->w,b2->h);
            e[i].explosion++;   
         }
         if ( (e[i].fighter_destroyed()==true) && (e[i].explosion>=9)){ e[i].set_position(-400,-400);}                 
     }    
}
     
void display_ground(BITMAP *b1,BITMAP *bb,int n,int ar_x[],int ar_y[]) {
     static int i = 0; 
     for (int j = 0; j < n ; j++)  masked_blit(b1,bb,0,0,ar_x[j],ar_y[j]+i,b1->w,b1->h);      
     i++;
     if (stop == 99) {i=0;}
          
}     


void display_forests(BITMAP *b1, BITMAP *b2,BITMAP *bb){
     static int i = 0;
     masked_blit(b1,bb,0,0,200,100+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,130,92+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,300,300+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,100,-100+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,400,-200+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,330,-210+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,100,-210+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,150,-425+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,130,-325+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,350,-525+i,b1->w,b1->h);
     masked_blit(b1,bb,0,0,250,-475+i,b1->w,b1->h);
     i++;
     if (stop == 99) {i=0;}                
}


void display_airport(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb){
     static int i = 0;
     masked_blit(b1,bb,0,0,200,-1100+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,80,-900+i,b2->w,b2->h);
     masked_blit(b2,bb,0,0,80,-800+i,b2->w,b2->h);
     masked_blit(b2,bb,0,0,80,-700+i,b2->w,b2->h);
     masked_blit(b3,bb,0,0,310,-900+i,b3->w,b3->h);
     masked_blit(b3,bb,0,0,310,-800+i,b3->w,b3->h);
     masked_blit(b3,bb,0,0,310,-700+i,b3->w,b3->h);
     i++;
     if (stop == 99) {i=0;}    
}

void display_road(BITMAP *b1,BITMAP *bb){
     static int i = 0;
     masked_blit(b1,bb,0,0,0,-1500+i,b1->w,b1->h);
     i++;
     if (stop == 99) {i=0;}
}

void display_cars(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb){
     static int i  = 0;
     masked_blit(b1,bb,0,0,200,-1420+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,400,-1220+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,600,-1520+i,b1->w,b1->h);
     masked_blit(b3,bb,0,0,110,-1120+i,b3->w,b3->h);
     masked_blit(b2,bb,0,0,210,-1600+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,310,-1720+i,b1->w,b1->h);
     masked_blit(b3,bb,0,0,400,-1700+i,b3->w,b3->h);
     i++;
     if (stop == 99) {i=0;}
}

void display_buildings(BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *bb){
     static int i  = 0;
     masked_blit(b1,bb,0,0,110,-1800+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,350,-1900+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,250,-2050+i,b1->w,b1->h);
     masked_blit(b2,bb,0,0,70,-2150+i,b2->w,b2->h);
     masked_blit(b1,bb,0,0,340,-2350+i,b1->w,b1->h);
     masked_blit(b3,bb,0,0,8,-3000+i,b3->w,b3->h);
     i++;
     if (stop == 99) {i=0;}     
}     
     
void display_fighter_info(BITMAP *bb,Fighter *f){
     textprintf(bb,font,0,440,makecol(255,255,255),"Energy: %d, points: %d",f->return_health(),points);
     textprintf(bb,font,0,460,makecol(255,255,255),"rockets: %d, bullets: %d, blasts: %d",pa_rockets_show,pa_bullets_show,pa_blasts_show);
}     

void display_level_1(Fighter *f,Enemy e[],Enemy e2[],Enemy e3[],Rocket r[], Rocket r2[], Rocket r3[],Bullet b[],Sonic_blast s[],BITMAP *b1,BITMAP *b2,BITMAP *b3,BITMAP *b4,BITMAP *b5,BITMAP *b6,BITMAP *b7,BITMAP *b8,BITMAP *b9,BITMAP *b10,BITMAP *b11,BITMAP *b12,BITMAP *b13,BITMAP *b14,BITMAP *b15,BITMAP *b16,BITMAP *b17,BITMAP *b18,BITMAP *bb,int ar_x[],int ar_y[],int pa_rockets_number,int enemy_rockets_number,int enemy_rockets_number2,int num,int num2,int num3){
     clear_to_color(bb,makecol(0,128,0));
     display_ground(b7,bb,100,ar_x,ar_y);
     display_buildings(b13,b14,b15,bb);
     display_forests(b5,b6,bb);
     display_airport(b9,b10,b11,bb);
     display_road(b12,bb);
     display_cars(b16,b17,b18,bb);
     
     for (int i = 0; i < pa_rockets_number; i++){
         if (r[i].return_status()==1){
           masked_blit((r[i].return_picture()),bb,0,0,(r[i].return_x()),(r[i].return_y()),(r[i].return_picture())->w,(r[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < enemy_rockets_number; i++){
         if (r2[i].return_status()==1){
           masked_blit((r2[i].return_picture()),bb,0,0,(r2[i].return_x()),(r2[i].return_y()),(r2[i].return_picture())->w,(r2[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < enemy_rockets_number2; i++){
         if (r3[i].return_status()==1){
           masked_blit((r3[i].return_picture()),bb,0,0,(r3[i].return_x()),(r3[i].return_y()),(r3[i].return_picture())->w,(r3[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < pa_bullets_number; i++){
         if (b[i].return_status()==1){
           masked_blit((b[i].return_picture()),bb,0,0,(b[i].return_x()),(b[i].return_y()),(b[i].return_picture())->w,(b[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < pa_blasts_number; i++){
         if (s[i].return_status()==1){
           line(bb,0,s[i].return_y(),640,s[i].return_y(),makecol(255,0,0));
           line(bb,0,s[i].return_y()-1,640,s[i].return_y()-1,makecol(255,0,0));
         }                                
     }
     if (f->fighter_destroyed()==false) masked_blit((f->return_picture()),bb,0,0,(f->return_x()),(f->return_y()),(f->return_picture())->w,(f->return_picture())->h);
     for (int i = 0; i < num; i++){
        if(e[i].fighter_destroyed()==false) {masked_blit((e[i].return_picture()),bb,0,0,(e[i].return_x()),(e[i].return_y()),(e[i].return_picture())->w,(e[i].return_picture())->h);}
     }
     for (int i = 0; i < num2; i++){
        if(e2[i].fighter_destroyed()==false) {masked_blit((e2[i].return_picture()),bb,0,0,(e2[i].return_x()),(e2[i].return_y()),(e2[i].return_picture())->w,(e2[i].return_picture())->h);}
     }
     for (int i = 0; i < num3; i++){
        if(e3[i].fighter_destroyed()==false) {masked_blit((e3[i].return_picture()),bb,0,0,(e3[i].return_x()),(e3[i].return_y()),(e3[i].return_picture())->w,(e3[i].return_picture())->h);}
     }
     display_explosion(e,b1,b2,bb,num);
     display_explosion(e2,b1,b2,bb,num2);
     display_explosion(e3,b1,b2,bb,num3);
     display_small_explosion(r2,b3,b4,bb,enemy_rockets_number);
     display_small_explosion(r3,b3,b4,bb,enemy_rockets_number2);
     display_small_explosion(r,b3,b4,bb,pa_rockets_number);
     display_fighter_explosion(f,b1,b2,bb);
     display_fighter_info(bb,f);       
     blit(bb,screen, 0,0,0,0, 640,480);     
}     
////

 
void menu(Player &p,int *ptr,Player best[]){
     int choice = 0; 
     BITMAP *buf=load_bmp("data/menu.bmp",default_palette);
           masked_blit(buf,screen,0,0,0,0,buf->w,buf->h);
           select_player(p);
           clear_disp();
           while (choice==0){
               masked_blit(buf,screen,0,0,0,0,buf->w,buf->h);
               rectfill(buf,31,148,414,439,makecol(0,0,0));  
               textprintf(buf,font,50,160,makecol(255,255,255),"Current player: %d. %s",p.number,p.return_name().c_str());
               textprintf(buf,font,50,200,makecol(255,255,255),"1. Set name");
               textprintf(buf,font,50,220,makecol(255,255,255),"2. Set difficulty");
               textprintf(buf,font,50,240,makecol(255,255,255),"3. START GAME");
               textprintf(buf,font,50,270,makecol(255,255,255),"4. View help");
               textprintf(buf,font,50,290,makecol(255,255,255),"5. Game options");
               textprintf(buf,font,50,310,makecol(255,255,255),"6. Change player");
               textprintf(buf,font,50,330,makecol(255,255,255),"7. Delete current player");
               textprintf(buf,font,50,350,makecol(255,255,255),"8. Player stats");
               textprintf(buf,font,50,370,makecol(255,255,255),"9. High scores");
               textprintf(buf,font,50,400,makecol(255,255,255),"0. Credits");
               textprintf(buf,font,50,420,makecol(255,255,255),"ESC -> EXIT");
               masked_blit(buf,screen,0,0,0,0,buf->w,buf->h);
               
               if (key[KEY_1]){set_name(p);}
               if (key[KEY_2]){set_difficulty();}
               if (key[KEY_3]){start_game(p,ptr); update_best(best,p); save_player(p);}
               if (key[KEY_4]){view_help();}
               if (key[KEY_5]){game_options(ptr_delay);}
               if (key[KEY_6]){select_player(p);}
               if (key[KEY_7]){delete_current_player(p);}
               if (key[KEY_8]){stats(p);}
               if (key[KEY_9]){show_high_scores(best);}
               if (key[KEY_0]){credits();}
               if (key[KEY_ESC]){choice=1;}
           }           
     destroy_bitmap(buf);     
}     
     
void start_level_1(Player &pp,int *ptr){
     //terrain and numbers
     int terrain_x[200]; for (int i = 0; i < 200; i++) terrain_x[i] = rand()%600;
     int terrain_y[200]; for (int i = 0; i < 200; i++) terrain_y[i] = rand()%3700-3100;
     //help_phase = 0;
     if (difficulty == 1){
       pa_rockets_number = 40;   
       pa_bullets_number = 400;
       pa_blasts_number = 15;
     }
     if (difficulty == 2){
       pa_rockets_number = 30;   
       pa_bullets_number = 300;
       pa_blasts_number = 10;
     }
     if (difficulty == 3){
       pa_rockets_number = 20;   
       pa_bullets_number = 250;
       pa_blasts_number = 5;
     }
     pa_rockets_show = pa_rockets_number;
     pa_bullets_show = pa_bullets_number;
     pa_blasts_show = pa_blasts_number;
     //enemies number
     int enemy_fighters_number = 20;
     int enemy_rockets_number = 200;
     
     int enemy_fighters_number2 = 40;
     int enemy_rockets_number2 = 500;
     
     int enemy_planes_number = 30;
     
     //enemy shooting
     int enemy_rockets_frequency = 12 / difficulty;
     int enemy_rockets_frequency2 = 12 / difficulty;
     
     int enemy_reload = 0;
     int *p = &enemy_reload;
     int enemy_j = 0;
     int *p2 =&enemy_j;
     
     int enemy_reload2 = 0;
     int *p3 = &enemy_reload2;
     int enemy_j2 = 0;
     int *p4 =&enemy_j2;
     //buffer
     buf = create_bitmap(640,480);
     
     //bitmaps
     BITMAP *b1 = load_bmp("data/pa_fighter.bmp",default_palette);
     BITMAP *b2 = load_bmp("data/enemy_fighter_2.bmp",default_palette);
     BITMAP *b3 = load_bmp("data/pa_rocket.bmp",default_palette);
     BITMAP *b4 = load_bmp("data/explode1.bmp",default_palette);
     BITMAP *b5 = load_bmp("data/explode2.bmp",default_palette);
     BITMAP *b6 = load_bmp("data/pa_bullet.bmp",default_palette);
     BITMAP *b7 = load_bmp("data/enemy_rocket.bmp",default_palette);
     BITMAP *b8 = load_bmp("data/s_explosion1.bmp",default_palette);
     BITMAP *b9 = load_bmp("data/s_explosion2.bmp",default_palette);
     BITMAP *b10 = load_bmp("data/tree1.bmp",default_palette);
     BITMAP *b11 = load_bmp("data/tree2.bmp",default_palette);
     BITMAP *b12 = load_bmp("data/terrain.bmp",default_palette);
     BITMAP *b13 = load_bmp("data/terrain2.bmp",default_palette);
     BITMAP *b14 = load_bmp("data/enemy_plane.bmp",default_palette);
     BITMAP *b15 = load_bmp("data/starting_line.bmp",default_palette);
     BITMAP *b16 = load_bmp("data/building4.bmp",default_palette);
     BITMAP *b17 = load_bmp("data/building5.bmp",default_palette);
     BITMAP *b18 = load_bmp("data/road.bmp",default_palette);
     BITMAP *b19 = load_bmp("data/building1.bmp",default_palette);
     BITMAP *b20 = load_bmp("data/building2.bmp",default_palette);
     BITMAP *b21 = load_bmp("data/building3.bmp",default_palette);
     BITMAP *b22 = load_bmp("data/car1.bmp",default_palette);
     BITMAP *b23 = load_bmp("data/car1.bmp",default_palette);
     BITMAP *b24 = load_bmp("data/car1_2.bmp",default_palette);
         
     //setting weapon arrays
     Rocket *rockets = new Rocket[pa_rockets_number];
     set_pa_rockets(rockets,b3);
     
     Rocket *rockets2 = new Rocket[enemy_rockets_number];
     set_enemy_rockets(rockets2,b7,enemy_rockets_number);
     
     Rocket *rockets3 = new Rocket[enemy_rockets_number2];
     set_enemy_rockets(rockets3,b7,enemy_rockets_number2);
     
     Bullet *bullets = new Bullet[pa_bullets_number];
     set_pa_bullets(bullets,b6);
     
     Sonic_blast *blasts = new Sonic_blast[pa_blasts_number];
     set_pa_blasts(blasts);
     ///creating main fighter
     Fighter fighter(300,415);
     Fighter *f = &fighter;
     f->set_picture(b1);
     ///creating enemies - array
     Enemy *enemies = new Enemy[enemy_fighters_number];
     set_enemy_fighters(enemies,b2,enemy_fighters_number,50);
     
     Enemy *enemies2 = new Enemy[enemy_planes_number];
     set_enemy_fighters(enemies2,b14,enemy_planes_number,20);
     
     Enemy *enemies3 = new Enemy[enemy_fighters_number2];
     set_enemy_fighters(enemies3,b2,enemy_fighters_number2,50);
          
     for (int i = 0; i < 20; i++){
         enemies[i].set_position(rand()%580+30,rand()%1500 - 1800);
     }     
          
     for (int i = 0; i<30; i++){
         enemies2[i].set_position(rand()%580+30,rand()%1000 - 7000);
     }    
     
     for (int i = 0; i < 20; i++){
         enemies3[i].set_position(rand()%580 + 20,rand()%2000 - 8000);
     }
     for (int i = 20; i < enemy_fighters_number2; i++){
         enemies3[i].set_position(rand()%580 + 20,rand()%2000 - 5000);
     }      
           
     ////level main loop     
     while( (pause()!=1) && (f->return_progress()< 3100) && (end_level_death(ptr,f)==false) ){ 
                         rest(delay); 
                         display_level_1(f,enemies,enemies2,enemies3,rockets,rockets2,rockets3,bullets,blasts,b4,b5,b8,b9,b10,b11,b12,b13,b15,b16,b17,b18,b19,b20,b21,b22,b23,b24,buf,terrain_x,terrain_y,pa_rockets_number,enemy_rockets_number,enemy_rockets_number2,enemy_fighters_number,enemy_planes_number,enemy_fighters_number2);
                         f->move();
                         check_pa_rocket(rockets,f);
                         check_pa_bullet(bullets,f);
                         check_pa_blast(blasts,f);
                         check_enemy_rocket(rockets2,enemies,enemy_rockets_frequency,p,p2,enemy_fighters_number,enemy_rockets_number,5);
                         check_enemy_rocket(rockets3,enemies3,enemy_rockets_frequency2,p3,p4,enemy_fighters_number2,enemy_rockets_number2,10);
                         f->shoot_rocket();
                         f->shoot_bullet();
                         f->shoot_blast();
                         //bullets
                         move_pa_bullet(bullets);
                         destroy_pa_bullet(bullets);
                         bullet_hit(bullets,enemies,enemy_fighters_number);
                         bullet_hit(bullets,enemies2,enemy_planes_number);
                         bullet_hit(bullets,enemies3,enemy_fighters_number2);
                         //rockets
                         move_pa_rocket(rockets);
                         destroy_pa_rocket(rockets);
                         rocket_hit(rockets,enemies,enemy_fighters_number);
                         rocket_hit(rockets,enemies2,enemy_planes_number);
                         rocket_hit(rockets,enemies3,enemy_fighters_number2);
                         //blasts
                         move_pa_blasts(blasts);
                         destroy_pa_blast(blasts);
                         blast_hit(blasts,enemies,enemy_fighters_number);
                         blast_hit(blasts,enemies2,enemy_planes_number);
                         blast_hit(blasts,enemies3,enemy_fighters_number2);
                         
                         ///enemy_rockets
                         move_enemy_rocket(rockets2,f,enemy_rockets_number);
                         destroy_enemy_rocket(rockets2,enemy_rockets_number);
                         rocket_hit(rockets2,f,enemy_rockets_number);
                         
                         move_enemy_rocket(rockets3,f,enemy_rockets_number2);
                         destroy_enemy_rocket(rockets3,enemy_rockets_number2);
                         rocket_hit(rockets3,f,enemy_rockets_number2);
                         
                         weapon_collisions(rockets,rockets2,bullets,blasts,enemy_rockets_number);
                         weapon_collisions(rockets,rockets3,bullets,blasts,enemy_rockets_number2);
                         vehicles_collisions(enemies,f,enemy_fighters_number);
                         vehicles_collisions(enemies2,f,enemy_planes_number);
                         vehicles_collisions(enemies3,f,enemy_fighters_number2);
                         //enemies move
                         for (int i = 0; i < enemy_fighters_number; i++){enemies[i].move(3);}
                         for (int i = 0; i < 20; i++){enemies3[i].move(3);}
                         for (int i = 20; i < enemy_fighters_number2; i++){enemies3[i].move_2(3,3);}
                         for (int i = 0; i < enemy_planes_number; i++){enemies2[i].move_2(4,4);}
                         
                         pause();
                         end_lev_stats(pp,f,0);
                         
                         /*textprintf(screen,font,40,40,makecol(255,255,255),"Energy: %d, points: %d,progress: %d",f->return_health(),points,f->return_progress());
                         if (f->fighter_destroyed()==true){
                            textprintf(screen,font,40,60,makecol(255,255,255),"111");   
                         }else{
                            textprintf(screen,font,40,60,makecol(255,255,255),"222");
                         }
                         textprintf(screen,font,40,80,makecol(255,255,255),"%d",stop); */                               
                         //end_level_death(ptr,f);                                                
     }
(*ptr)=99;
display_level_1(f,enemies,enemies2,enemies3,rockets,rockets2,rockets3,bullets,blasts,b4,b5,b8,b9,b10,b11,b12,b13,b15,b16,b17,b18,b19,b20,b21,b22,b23,b24,buf,terrain_x,terrain_y,pa_rockets_number,enemy_rockets_number,enemy_rockets_number2,enemy_fighters_number,enemy_planes_number,enemy_fighters_number2);
(*ptr)=0;          
///deleting dynamic arrays
delete [] enemies;
delete [] enemies2;
delete [] enemies3;     
delete [] rockets; 
delete [] rockets2;
delete [] rockets3;
delete [] bullets;
delete [] blasts;
///destroying bitmaps
destroy_bitmap(b1); destroy_bitmap(b2); destroy_bitmap(b3); destroy_bitmap(b4); destroy_bitmap(b5); destroy_bitmap(b6);
destroy_bitmap(b7); destroy_bitmap(b8); destroy_bitmap(b9); destroy_bitmap(b10); destroy_bitmap(b11); destroy_bitmap(b12);
destroy_bitmap(b13);  destroy_bitmap(b14); destroy_bitmap(b15);  destroy_bitmap(b16); destroy_bitmap(b17); destroy_bitmap(b18);
destroy_bitmap(b19); destroy_bitmap(b20);  destroy_bitmap(b21); destroy_bitmap(b22); destroy_bitmap(b23);  destroy_bitmap(b24);                           
}

      
///////////PROFILE/////
Player load_player(char c[]){
       int *p = &difficulty;
       ifstream file1(c);
       string tmp;
       Player player;
       int num;
       int i=0;
       if (file1.is_open()){
          getline(file1,tmp);
          player.set_name(tmp);
          for (i=0;i<2;i++){
                file1>>num;
                player.fill_scores(i,num);                
          }
          file1>>(*p);
          file1.close();
          return player;                           
       }                        
}
void clear_disp(){
     rectfill(screen,31,148,414,439,makecol(0,0,0));
}
void set_name(Player &p){
     clear_disp();
     int i = 0;
     int choice = 0;
     string tmp;
     textprintf(screen,font,50,160,makecol(255,255,255),"Enter name: ");
     textprintf(screen,font,50,180,makecol(255,255,255),"ENTER to accept, SPACE to delete a letter");
     while (choice==0){
      if( (i>=0) && (i<=120)){           
       if (key[KEY_A]){tmp=tmp+'A'; textprintf(screen,font,50+i,200,makecol(255,255,255),"A"); i=i+10; rest(200);}
       if (key[KEY_B]){tmp=tmp+'B'; textprintf(screen,font,50+i,200,makecol(255,255,255),"B"); i=i+10; rest(200);}
       if (key[KEY_C]){tmp=tmp+'C'; textprintf(screen,font,50+i,200,makecol(255,255,255),"C"); i=i+10; rest(200);}
       if (key[KEY_D]){tmp=tmp+'D'; textprintf(screen,font,50+i,200,makecol(255,255,255),"D"); i=i+10; rest(200);}
       if (key[KEY_E]){tmp=tmp+'E'; textprintf(screen,font,50+i,200,makecol(255,255,255),"E"); i=i+10; rest(200);}
       if (key[KEY_F]){tmp=tmp+'F'; textprintf(screen,font,50+i,200,makecol(255,255,255),"F"); i=i+10; rest(200);}
       if (key[KEY_G]){tmp=tmp+'G'; textprintf(screen,font,50+i,200,makecol(255,255,255),"G"); i=i+10; rest(200);}
       if (key[KEY_H]){tmp=tmp+'H'; textprintf(screen,font,50+i,200,makecol(255,255,255),"H"); i=i+10; rest(200);}
       if (key[KEY_I]){tmp=tmp+'I'; textprintf(screen,font,50+i,200,makecol(255,255,255),"I"); i=i+10; rest(200);}
       if (key[KEY_J]){tmp=tmp+'J'; textprintf(screen,font,50+i,200,makecol(255,255,255),"J"); i=i+10; rest(200);}
       if (key[KEY_K]){tmp=tmp+'K'; textprintf(screen,font,50+i,200,makecol(255,255,255),"K"); i=i+10; rest(200);}
       if (key[KEY_L]){tmp=tmp+'L'; textprintf(screen,font,50+i,200,makecol(255,255,255),"L"); i=i+10; rest(200);}
       if (key[KEY_M]){tmp=tmp+'M'; textprintf(screen,font,50+i,200,makecol(255,255,255),"M"); i=i+10; rest(200);}
       if (key[KEY_N]){tmp=tmp+'N'; textprintf(screen,font,50+i,200,makecol(255,255,255),"N"); i=i+10; rest(200);}
       if (key[KEY_O]){tmp=tmp+'O'; textprintf(screen,font,50+i,200,makecol(255,255,255),"O"); i=i+10; rest(200);}
       if (key[KEY_P]){tmp=tmp+'P'; textprintf(screen,font,50+i,200,makecol(255,255,255),"P"); i=i+10; rest(200);}
       if (key[KEY_Q]){tmp=tmp+'Q'; textprintf(screen,font,50+i,200,makecol(255,255,255),"Q"); i=i+10; rest(200);}
       if (key[KEY_R]){tmp=tmp+'R'; textprintf(screen,font,50+i,200,makecol(255,255,255),"R"); i=i+10; rest(200);}
       if (key[KEY_S]){tmp=tmp+'S'; textprintf(screen,font,50+i,200,makecol(255,255,255),"S"); i=i+10; rest(200);}    
       if (key[KEY_T]){tmp=tmp+'T'; textprintf(screen,font,50+i,200,makecol(255,255,255),"T"); i=i+10; rest(200);}
       if (key[KEY_U]){tmp=tmp+'U'; textprintf(screen,font,50+i,200,makecol(255,255,255),"U"); i=i+10; rest(200);}
       if (key[KEY_V]){tmp=tmp+'V'; textprintf(screen,font,50+i,200,makecol(255,255,255),"V"); i=i+10; rest(200);}
       if (key[KEY_W]){tmp=tmp+'W'; textprintf(screen,font,50+i,200,makecol(255,255,255),"W"); i=i+10; rest(200);}
       if (key[KEY_X]){tmp=tmp+'X'; textprintf(screen,font,50+i,200,makecol(255,255,255),"X"); i=i+10; rest(200);}
       if (key[KEY_Y]){tmp=tmp+'Y'; textprintf(screen,font,50+i,200,makecol(255,255,255),"Y"); i=i+10; rest(200);}
       if (key[KEY_Z]){tmp=tmp+'Z'; textprintf(screen,font,50+i,200,makecol(255,255,255),"Z"); i=i+10; rest(200);}
       if (key[KEY_SPACE] && tmp!=""){tmp.erase(tmp.end()-1,tmp.end()); i=i-10;  rectfill(screen,50+i,200,60+i,212,makecol(0,0,0)); rest(200);}
       if (key[KEY_ENTER] && tmp!=""){choice = 1; textprintf(screen,font,50,220,makecol(255,255,255),"Name updated!"); rest(300);}
      }  
     }
     p.set_name(tmp);
     clear_disp();
     save_player(p);            
}

void select_player(Player &p){
     clear_disp();
     int choice = 0;
     string ppp,ppp2,ppp3;
     ifstream tmp("data/1.paf");
     tmp>>ppp;
     tmp.close();
     const char* p1 = ppp.c_str();

     ifstream tmp2("data/2.paf");
     tmp2>>ppp2;
     tmp2.close();
     const char* p2 = ppp2.c_str();
     
     ifstream tmp3("data/3.paf");
     tmp3>>ppp3;
     tmp3.close();
     const char* p3 = ppp3.c_str();
       
     while(choice==0){
         textprintf(screen,font,50,160,makecol(255,255,255),"Select player by pressing number: ");
         textprintf(screen,font,50,180,makecol(255,255,255),"1: %s",p1);
         textprintf(screen,font,50,200,makecol(255,255,255),"2: %s",p2);
         textprintf(screen,font,50,220,makecol(255,255,255),"3: %s",p3);             
         if (key[KEY_1]){p = load_player("data/1.paf"); rest(200); choice = 1; p.number=1;}
         if (key[KEY_2]){p = load_player("data/2.paf"); rest(200); choice = 1; p.number=2;}
         if (key[KEY_3]){p = load_player("data/3.paf"); rest(200); choice = 1; p.number=3;}             
     }
     textprintf(screen,font,50,240,makecol(0,0,0),"Load successful!");
     clear_disp();
     rest(200);                 
}

void set_difficulty(){
     int choice = 0;
     clear_disp();
     rest(200);
     while (choice==0){
                  textprintf(screen,font,50,160,makecol(255,255,255),"Select difficulty: ");
                  textprintf(screen,font,50,180,makecol(255,255,255),"Current difficulty: %d",difficulty);
                  textprintf(screen,font,50,200,makecol(255,255,255),"1. Easy.");
                  textprintf(screen,font,50,220,makecol(255,255,255),"2. Medium.");
                  textprintf(screen,font,50,240,makecol(255,255,255),"3. Hard.");
                  
                  if (key[KEY_1]){difficulty = 1; textprintf(screen,font,50,320,makecol(255,255,255),"Difficulty selected!"); choice =1; rest(300); }
                  if (key[KEY_2]){difficulty = 2; textprintf(screen,font,50,320,makecol(255,255,255),"Difficulty selected!"); choice =1; rest(300); }
                  if (key[KEY_3]){difficulty = 3; textprintf(screen,font,50,320,makecol(255,255,255),"Difficulty selected!"); choice =1; rest(300); }
     }
     clear_disp();     
}     
 
void save_player(Player &p){
     ofstream f;
     switch (p.number){
            case 1: f.open("data/1.paf"); break;
            case 2: f.open("data/2.paf"); break;
            case 3: f.open("data/3.paf"); break;          
     }       
     f<<p.return_name(); f<<"\n";
     int* ar = p.return_scores();
     f<<ar[0]; f<<"\n";
     f<<ar[1]; f<<"\n";
     f<<difficulty;
     f.close();     
}

void view_help(){
    clear_disp(); 
    while (!key[KEY_ENTER]){ 
     textprintf(screen,font,50,160,makecol(255,255,255),"STEERING:"); 
     textprintf(screen,font,50,180,makecol(255,255,255),"A-rocket, S-machine gun, D-sonic blast.");
     textprintf(screen,font,50,200,makecol(255,255,255),"Use arrows to move your plane.");
     textprintf(screen,font,50,220,makecol(255,255,255),"OPTIONS:");
     textprintf(screen,font,50,240,makecol(255,255,255),"You can change game speed in OPTIONS.");
     textprintf(screen,font,50,260,makecol(255,255,255),"You can also change difficulty.");
     textprintf(screen,font,50,280,makecol(255,255,255),"It will affect your score after");
     textprintf(screen,font,50,300,makecol(255,255,255),"completing each level.");
     textprintf(screen,font,50,320,makecol(255,255,255),"Don't open game *.paf files.");
     textprintf(screen,font,50,340,makecol(255,255,255),"It may damage your game.");
     textprintf(screen,font,50,370,makecol(255,255,255),"Press ENTER to continue.");
    }
    
    rest(200);
    clear_disp();  
}

void stats(Player &p){
    clear_disp();
    int *ar=p.return_scores(); 
    while (!key[KEY_ENTER]){
          textprintf(screen,font,50,160,makecol(255,255,255),"PLAYER STATS:");
          textprintf(screen,font,50,180,makecol(255,255,255),"LEVEL 1 score: %d",ar[0]);
          textprintf(screen,font,50,200,makecol(255,255,255),"LEVEL 2 score: %d",ar[1]);
          textprintf(screen,font,50,220,makecol(255,255,255),"DIFFICULTY: %d",difficulty);
          textprintf(screen,font,50,270,makecol(255,255,255),"Press ENTER to continue."); 
    }
    rest(200);
    clear_disp();       
}

void start_game(Player &p,int *ptr){
    clear_disp();
    rest(200);
    int choice=0;
    int *ar = p.return_scores();
    while (choice==0){
       textprintf(screen,font,50,160,makecol(255,255,255),"CHOOSE LEVEL:");
       textprintf(screen,font,50,180,makecol(255,255,255),"1. THE BASE.");
       if (ar[0]>0){textprintf(screen,font,50,200,makecol(255,255,255),"2. ISLES.");}
       
       if (key[KEY_1]){start_level_1(p,ptr); choice = 1;}
       if ( (key[KEY_2]) && (ar[0]>0) ){start_level_2(p,ptr); choice = 1;}
    }   
    
    rest(200);
    clear_disp();
}
////////////////////!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
bool end_level_death(int *p, Fighter *f){
     if (f->fighter_destroyed()==true){(*p)++;}
     if ((*p)==100) {return true;}else{return false;}
}


void load_best(Player best[]){
        ifstream file;
        string tmp;
        int num2;
        
        file.open("data/high_scores.paf",ifstream::in);
        for (int i = 0; i<5; i++){
            file>>tmp;
            best[i].set_name(tmp);
            file>>num2;
            best[i].set_overall(num2);            
        }    
        file.close();       
}

void update_best(Player best[],Player &p){
        Player copy[5];
        for (int i=0;i<5;i++){
            copy[i].set_name(best[i].return_name());
            copy[i].set_overall(best[i].return_overall());
        }      
        for (int i = 0; i < 5; i++){
            if ( (p.return_name()==best[i].return_name()) && (p.return_overall_p()<=best[i].return_overall()) ){break;} 
            if (p.return_overall_p()>best[i].return_overall()){
               best[i].set_name(p.return_name());
               best[i].set_overall(p.return_overall_p());                                                
               while ((i + 1) < 5){
                     best[i+1] = copy[i];
                     i++;                                 
               }
            break;                                                           
            }                                                   
        }
        ofstream file;
        file.open("data/high_scores.paf",ofstream::out);
        for (int i = 0; i<5;i++){
            file<<best[i].return_name(); file<<endl;
            file<<best[i].return_overall(); file<<endl;
        }    
        file.close();                    
}

void show_high_scores(Player best[]){ 
     const char* name1 = best[0].return_name().c_str();
     const char* name2 = best[1].return_name().c_str();
     const char* name3 = best[2].return_name().c_str();
     const char* name4 = best[3].return_name().c_str();
     const char* name5 = best[4].return_name().c_str();
     rest(300);
     clear_disp();
     int reset = 0;
     while (!key[KEY_ENTER]){    
       textprintf(screen,font,50,160,makecol(255,255,255),"HIGH SCORES");
       textprintf(screen,font,50,180,makecol(255,255,255),"%s",name1);
       textprintf(screen,font,50,200,makecol(255,255,255),"%s",name2);
       textprintf(screen,font,50,220,makecol(255,255,255),"%s",name3);
       textprintf(screen,font,50,240,makecol(255,255,255),"%s",name4);
       textprintf(screen,font,50,260,makecol(255,255,255),"%s",name5);
       for (int i =0; i<5 ;i++){textprintf(screen,font,180,180 + 20*i,makecol(255,255,255),"%d points",best[i].return_overall());}
       textprintf(screen,font,50,280,makecol(255,255,255),"Press ENTER to continue");
       textprintf(screen,font,50,300,makecol(255,255,255),"or R to reset scores");
       if (key[KEY_R]){reset=1;}
       if (reset==1){ 
          textprintf(screen,font,50,320,makecol(255,255,255),"Confirm Yes/No (Y/N)");
          if (key[KEY_Y]){
             for (int i =0; i<5; i++){
                 best[i].set_name("---");
                 best[i].set_overall(0); 
             }
             
             ofstream file;
             file.open("data/high_scores.paf",ofstream::out);
             for (int i = 0; i<5;i++){
                 file<<best[i].return_name(); file<<"\n";
                 file<<best[i].return_overall(); file<<"\n";
             }    
             file.close(); 
             break;                
          }
          if (key[KEY_N]){rectfill(screen,50,320,200,380,makecol(0,0,0));reset=0;}                
       }                
     }
     rest(300);           
}                       

/************************ALLEGRO_INITIALIZATION_AND_DEINITIALIZATION_AND_TIMERS*********************/

void init() {
	int d, res, depth, screen_mode;
	
	ifstream file("data/settings.paf");
	file>>screen_mode;
	file.close();
	
	
	allegro_init();
	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	set_color_depth(depth);
	if (screen_mode==1){
	  res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
    }
    if (screen_mode==2){
	  res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
    }  
	if (res != 0) {
		allegro_message(allegro_error);
		exit(-1);
	}

	install_timer();
	install_keyboard();
	install_mouse();
	/* add other initializations here */
}

void deinit() {
    remove_int(inc_speed);
	clear_keybuf();
	/* add other deinitializations here */
}                                   

void end_lev_stats(Player &p,Fighter *f,int a1){
    if (f->return_progress()==3099){
      rectfill(screen,100,100,540,380,makecol(0,0,0));                              
      for (int i = 0; i<5; i++){
       rect(screen,100+i,100+i,540-i,380-i,makecol(0,0,200));
      }
      int num[4];
      int high = p.return_scores()[a1];
      num[0] = points * 100;
      if (difficulty == 1){num[1]=1000;}
      if (difficulty == 2){num[1]=2000;}
      if (difficulty == 3){num[1]=5000;}
      num[2] = f->return_health() * 20;
      num[3] = num[0] + num[1] +num[2];
      if (high < num[3]) {p.fill_scores(a1,num[3]);}
       
      textprintf(screen,font,150,140,makecol(255,255,255),"MISSION SUCCESSFUL");
      textprintf(screen,font,120,160,makecol(255,255,255),"Enemies destroyed:       %d",num[0]);
      textprintf(screen,font,120,180,makecol(255,255,255),"Difficulty bonus:        %d",num[1]);
      textprintf(screen,font,120,200,makecol(255,255,255),"Energy bonus:            %d",num[2]);
      textprintf(screen,font,120,220,makecol(255,255,255),"Total:                   %d",num[3]);
      textprintf(screen,font,120,240,makecol(255,255,255),"PRESS ENTER TO CONTINUE");                                  
      rest(500);
      while(!key[KEY_ENTER]){
      }
      rest(500);                       
    }       
}

int pause(){
    if(key[KEY_ESC]){
     int exit = 0;
     rectfill(screen,200,200,440,280,makecol(0,0,0));
     for (int i = 0; i<5; i++){
       rect(screen,200+i,200+i,440-i,280-i,makecol(0,0,200));
     }
     textprintf(screen,font,250,240,makecol(255,255,255),"PAUSED, QUIT? (Y/N)");
     rest(300);
     while ( exit == 0){
           if (key[KEY_Y]){rest(200); return 1;}
           if (key[KEY_N]){rest(200); return 0;}
     }
    }       
}          

void delete_current_player(Player &p){
     clear_disp();
     textprintf(screen,font,50,160,makecol(255,255,255),"Do you want to delete ");
     textprintf(screen,font,50,180,makecol(255,255,255),"player %s ?",p.return_name().c_str());
     textprintf(screen,font,50,200,makecol(255,255,255),"Confirm (Y/N)");
     rest(200);
     int choice = 0;
     while (choice == 0){
       if (key[KEY_Y]){
         p.set_name("---");
         for (int i = 0; i<2;i++){p.fill_scores(i,0);}
         difficulty = 1;              
         choice = 1;
         save_player(p);
       }
       if (key[KEY_N]){choice = 1;}
     }       
}

void game_options(int *ptr){
     int speed;
     int screen_mode;
     
     ifstream file("data/settings.paf");
     file>>screen_mode;
     file>>speed;
     file.close();
     
     BITMAP *buf = create_bitmap(330,291);
     clear_to_color(buf,makecol(0,0,0));
     int escape = 0;
     while  (escape == 0){
       textprintf(buf,font,10,10,makecol(255,255,255),"Press UP ARROW to increase game speed");
       textprintf(buf,font,10,30,makecol(255,255,255),"and DOWN ARROW to decrease it.");
       textprintf(buf,font,10,50,makecol(255,255,255),"Press SPACE to switch screen mode.");
       textprintf(buf,font,10,70,makecol(255,255,255),"Current game speed: %d",speed);
       if (screen_mode == 1) {
         textprintf(buf,font,10,90,makecol(255,255,255),"Screen mode: WINDOWED (640 x 480)");
       }
       if (screen_mode == 2) {
         textprintf(buf,font,10,90,makecol(255,255,255),"Screen mode: FULLSCREEN (640 x 480)");
       }  
       textprintf(buf,font,10,110,makecol(255,255,255),"Press ESC to quit options.");
       textprintf(buf,font,10,140,makecol(255,255,255),"Changing screen mode requires");
       textprintf(buf,font,10,160,makecol(255,255,255),"restarting game.");
       if (key[KEY_SPACE]){
          if (screen_mode == 2){screen_mode = 1; rest(200); }                    
       }
       if (key[KEY_SPACE]){
          if (screen_mode == 1){screen_mode = 2; rest(200); }                    
       }
       if (key[KEY_ESC]){
                         
         ofstream file("data/settings.paf");
         file<<screen_mode<<"\n";
         file<<speed<<"\n";
         file.close();
                         
         escape = 1;
         rest(300);
       }
       if ( (key[KEY_UP]) ){
            rest(200); 
            if (speed<=9) {speed++;}
            (*ptr) = 50 - 5*(speed-1);
       }
       if ( (key[KEY_DOWN]) ){
            rest(200); 
            if (speed>=2) {speed--;}
            (*ptr) = 50 - 5*(speed-1); 
       }
     masked_blit(buf,screen,0,0,31,148,buf->w,buf->h);
     rectfill(buf,0,0,310,291,makecol(0,0,0));                      
     }  
}

void display_level_2(Fighter *f,Enemy e[],Enemy e2[],Enemy e3[],Enemy e4[],Enemy e5[],Enemy e6[],Rocket r[],Rocket r2[],Rocket r3[],Rocket r4[],Bullet bl[],Sonic_blast s[],Wave waves[],BITMAP *b[],BITMAP *bb,int n1,int n2,int n3,int n4,int n5,int n6,int m,int m2,int m3, int m4 ,int m5 ,int m6){
     clear_to_color(bb,makecol(0,0,255));
     for (int i = 0; i<250;i++){
         masked_blit(waves[i].b[waves[i].start],bb,0,0,waves[i].x,waves[i].y,waves[i].b[waves[i].start]->w,waves[i].b[waves[i].start]->h);
         if (waves[i].phase ==13){waves[i].phase = 0;} else{waves[i].phase++;}
         if ( (waves[i].start == 3) ){waves[i].start = 0;}
         if  (waves[i].phase == 12) {waves[i].start++;}
         waves[i].y++;
     }
     display_isles(bb,b);
     masked_blit(f->return_picture(),bb,0,0,f->return_x(),f->return_y(),f->return_picture()->w,f->return_picture()->h);
     
     for (int i = 0; i < m; i++){
         if (r[i].return_status()==1){
           masked_blit((r[i].return_picture()),bb,0,0,(r[i].return_x()),(r[i].return_y()),(r[i].return_picture())->w,(r[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < m2; i++){
         if (r2[i].return_status()==1){
           masked_blit((r2[i].return_picture()),bb,0,0,(r2[i].return_x()),(r2[i].return_y()),(r2[i].return_picture())->w,(r2[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < m3; i++){
         if (r3[i].return_status()==1){
           masked_blit((r3[i].return_picture()),bb,0,0,(r3[i].return_x()),(r3[i].return_y()),(r3[i].return_picture())->w,(r3[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < m4; i++){
         if (r4[i].return_status()==1){
           masked_blit((r4[i].return_picture()),bb,0,0,(r4[i].return_x()),(r4[i].return_y()),(r4[i].return_picture())->w,(r4[i].return_picture())->h);
         }                                
     }
     for (int i = 0; i < m5; i++){
         if (bl[i].return_status()==1){
           masked_blit((bl[i].return_picture()),bb,0,0,(bl[i].return_x()),(bl[i].return_y()),(bl[i].return_picture())->w,(bl[i].return_picture())->h);
         } 
     }
     for (int i = 0; i < m6; i++){
         if (s[i].return_status()==1){
           line(bb,0,s[i].return_y(),640,s[i].return_y(),makecol(255,0,0));
           line(bb,0,s[i].return_y()-1,640,s[i].return_y()-1,makecol(255,0,0));
         }                                
     }    
     
     for (int i = 0 ; i < n1 ; i++){
         masked_blit(e[i].return_picture(),bb,0,0,e[i].return_x(),e[i].return_y(),e[i].return_picture()->w,e[i].return_picture()->h);         
     }
     for (int i = 0 ; i < n2 ; i++){
         masked_blit(e2[i].return_picture(),bb,0,0,e2[i].return_x(),e2[i].return_y(),e2[i].return_picture()->w,e2[i].return_picture()->h);          
     }
     for (int i = 0 ; i < n3 ; i++){
         masked_blit(e3[i].return_picture(),bb,0,0,e3[i].return_x(),e3[i].return_y(),e3[i].return_picture()->w,e3[i].return_picture()->h);          
     }
     for (int i = 0 ; i < n4 ; i++){
         masked_blit(e4[i].return_picture(),bb,0,0,e4[i].return_x(),e4[i].return_y(),e4[i].return_picture()->w,e4[i].return_picture()->h);         
     }
     for (int i = 0 ; i < n5 ; i++){
         masked_blit(e5[i].return_picture(),bb,0,0,e5[i].return_x(),e5[i].return_y(),e5[i].return_picture()->w,e5[i].return_picture()->h);          
     }
     for (int i = 0 ; i < n6 ; i++){
         masked_blit(e6[i].return_picture(),bb,0,0,e6[i].return_x(),e6[i].return_y(),e6[i].return_picture()->w,e6[i].return_picture()->h);          
     }
     
     display_explosion(e,b[3],b[4],bb,n1);
     display_explosion(e2,b[3],b[4],bb,n2);
     display_explosion(e3,b[3],b[4],bb,n3);
     display_explosion(e4,b[3],b[4],bb,n4);
     display_explosion(e5,b[3],b[4],bb,n5);
     display_explosion(e6,b[3],b[4],bb,n6);
     display_small_explosion(r2,b[7],b[8],bb,m2);
     display_small_explosion(r3,b[7],b[8],bb,m3);
     display_small_explosion(r4,b[7],b[8],bb,m4);
     display_small_explosion(r,b[7],b[8],bb,m);
     display_fighter_explosion(f,b[3],b[4],bb);
     
     display_fighter_info(bb,f);
     blit(bb,screen,0,0,0,0,640,480);         
}     

void start_level_2(Player &pp,int *ptr){
     //creating waves
     Wave waves[250];
     for (int i =0; i <250; i++){
         waves[i].b[0]=load_bmp("data/wave1.bmp",default_palette); 
         waves[i].b[1]=load_bmp("data/wave2.bmp",default_palette); 
         waves[i].b[2]=load_bmp("data/wave3.bmp",default_palette); 
         waves[i].b[3]=load_bmp("data/wave4.bmp",default_palette);
         waves[i].start = rand()%4;
         waves[i].phase = 0;
         waves[i].x = rand()%620 + 10;
         waves[i].y = rand()%3750 - 3000;  
     }
     
     if (difficulty == 1){
       pa_rockets_number = 50;   
       pa_bullets_number = 500;
       pa_blasts_number = 20;
     }
     if (difficulty == 2){
       pa_rockets_number = 40;   
       pa_bullets_number = 400;
       pa_blasts_number = 15;
     }
     if (difficulty == 3){
       pa_rockets_number = 30;   
       pa_bullets_number = 300;
       pa_blasts_number = 5;
     }
     pa_rockets_show = pa_rockets_number;
     pa_bullets_show = pa_bullets_number;
     pa_blasts_show = pa_blasts_number;
     
     int enemies_number_1 = 8;
     int enemies_number_2 = 16;
     int enemies_number_3 = 30;
     int enemies_number_4 = 30;
     int enemies_number_5 = 20;
     int enemies_number_6 = 7;
     
     int enemy_rockets_number = 600;
     int enemy_rockets_number2 = 600;
     int enemy_rockets_number3 = 600;
     
     int enemy_rockets_frequency = 12 / difficulty;
     int enemy_rockets_frequency2 = 12 / difficulty;
     int enemy_rockets_frequency3 = 12 / difficulty;
     
     int enemy_reload = 0;
     int *p = &enemy_reload;
     int enemy_j = 0;
     int *p2 =&enemy_j;
     
     int enemy_reload2 = 0;
     int *p3 = &enemy_reload2;
     int enemy_j2 = 0;
     int *p4 =&enemy_j2;
     
     int enemy_reload3 = 0;
     int *p5 = &enemy_reload3;
     int enemy_j3 = 0;
     int *p6 =&enemy_j3;
     
     buf = create_bitmap(640,480);
     BITMAP *b[25];
     for (int i = 0 ; i < 20; i++){b[i] = NULL;}
     b[0] = load_bmp("data/pa_fighter.bmp",default_palette);
     b[1] = load_bmp("data/enemy_fighter.bmp",default_palette);
     b[2] = load_bmp("data/pa_rocket.bmp",default_palette);
     b[3] = load_bmp("data/explode1.bmp",default_palette);
     b[4] = load_bmp("data/explode2.bmp",default_palette);
     b[5] = load_bmp("data/pa_bullet.bmp",default_palette);
     b[6] = load_bmp("data/enemy_rocket_2.bmp",default_palette);
     b[7] = load_bmp("data/s_explosion1.bmp",default_palette);
     b[8] = load_bmp("data/s_explosion2.bmp",default_palette);
     b[9] = load_bmp("data/island1.bmp",default_palette);
     b[10] = load_bmp("data/island2.bmp",default_palette);
     b[11] = load_bmp("data/island3.bmp",default_palette);
     b[12] = load_bmp("data/island4.bmp",default_palette);
     b[13] = load_bmp("data/island5.bmp",default_palette);
     b[14] = load_bmp("data/island6.bmp",default_palette);
     b[15] = load_bmp("data/island7.bmp",default_palette);
     b[16] = load_bmp("data/enemy_big_rocket.bmp",default_palette);
     b[17] = load_bmp("data/enemy_plane_2.bmp",default_palette);
     b[18] = load_bmp("data/enemy_fighter_3.bmp",default_palette);
     b[19] = load_bmp("data/enemy_rocket_3.bmp",default_palette);
     
     Fighter fighter(300,415);
     Fighter *f = &fighter;
     f->set_picture(b[0]);
     
     Enemy *enemies = new Enemy[enemies_number_1];
     set_enemy_fighters(enemies,b[16],enemies_number_1,70);
     
     Enemy *enemies2 = new Enemy[enemies_number_2];
     set_enemy_fighters(enemies2,b[16],enemies_number_2,70);
     
     Enemy *enemies3 = new Enemy[enemies_number_3];     
     set_enemy_fighters(enemies3,b[1],enemies_number_3,100);
     
     Enemy *enemies4 = new Enemy[enemies_number_4];
     set_enemy_fighters(enemies4,b[17],enemies_number_4,60);
     
     Enemy *enemies5 = new Enemy[enemies_number_5];
     set_enemy_fighters(enemies5,b[1],enemies_number_5,100);
     
     Enemy *enemies6 = new Enemy[enemies_number_6];
     set_enemy_fighters(enemies6,b[18],enemies_number_6,200);
     
     Rocket *rockets = new Rocket[pa_rockets_number];
     set_pa_rockets(rockets,b[2]);
     
     Rocket *rockets2 = new Rocket[enemy_rockets_number];
     set_enemy_rockets(rockets2,b[6],enemy_rockets_number);
     
     Rocket *rockets3 = new Rocket[enemy_rockets_number2];
     set_enemy_rockets(rockets3,b[6],enemy_rockets_number2);
     
     Rocket *rockets4 = new Rocket[enemy_rockets_number3];
     set_enemy_rockets(rockets4,b[19],enemy_rockets_number3);
     
     Bullet *bullets = new Bullet[pa_bullets_number];
     set_pa_bullets(bullets,b[5]);
     
     Sonic_blast *blasts = new Sonic_blast[pa_blasts_number];
     set_pa_blasts(blasts);
     
     for (int i = 0; i <4; i++){
         enemies[i].set_position(5 + 165 * i,-100);
     }
     for (int i = 4; i <8; i++){
         enemies[i].set_position(5 + 165 * (i-4),-300);
     }
     for (int i = 0; i < 4; i++){
         enemies2[i].set_position(5 + 115 * i,-400 + 10 *i );
     }
     for (int i = 4; i < 8; i++){
         enemies2[i].set_position(550 - 115 * (i-4),-700 + 10 *(i-4) );
     }
     for (int i = 8; i < 12; i++){
         enemies2[i].set_position(30 + 165*(i-8),-900);
     }
     for (int i = 12; i < 16; i++){
         enemies2[i].set_position(30 + 165*(i-12),-1000);
     }    
     for (int i = 0; i < 30; i++){
         enemies3[i].set_position(rand()%540 + 15,rand()%3000 - 4000);
     }
     for (int i = 0; i < 30; i++){
         enemies4[i].set_position(rand()%540 + 15,rand()%1300 - 3300);
     }
     for (int i = 0; i < 20; i++){
         enemies5[i].set_position(rand()%540 + 15,rand()%1300 - 4500);
     }
     for (int i = 0; i < 7; i++){
         enemies6[i].set_position(rand()%540 + 15,rand()%1000 - 5000);
     }         
       
     while( (pause()!=1) && (f->return_progress()< 3100) && (end_level_death(ptr,f)==false) ){
            rest(delay);
            display_level_2(f,enemies,enemies2,enemies3,enemies4,enemies5,enemies6,rockets,rockets2,rockets3,rockets4,bullets,blasts,waves,b,buf,enemies_number_1,enemies_number_2,enemies_number_3,enemies_number_4,enemies_number_5,enemies_number_6,pa_rockets_number,enemy_rockets_number,enemy_rockets_number2,enemy_rockets_number3,pa_bullets_number,pa_blasts_number);
            f->move();
            
            check_pa_rocket(rockets,f);
            check_pa_bullet(bullets,f);
            check_pa_blast(blasts,f);
            check_enemy_rocket(rockets2,enemies3,enemy_rockets_frequency,p,p2,enemies_number_3,enemy_rockets_number,5);
            check_enemy_rocket(rockets3,enemies5,enemy_rockets_frequency2,p3,p4,enemies_number_5,enemy_rockets_number2,10);
            check_enemy_rocket(rockets4,enemies6,enemy_rockets_frequency2,p5,p6,enemies_number_6,enemy_rockets_number3,10);
            
            f->shoot_rocket();
            f->shoot_bullet();
            f->shoot_blast();
            
            move_pa_bullet(bullets);
            destroy_pa_bullet(bullets);
            bullet_hit(bullets,enemies,enemies_number_1);
            bullet_hit(bullets,enemies2,enemies_number_2);
            bullet_hit(bullets,enemies3,enemies_number_3);
            bullet_hit(bullets,enemies4,enemies_number_4);
            bullet_hit(bullets,enemies5,enemies_number_5);
            bullet_hit(bullets,enemies6,enemies_number_6);
            
            move_pa_rocket(rockets);
            destroy_pa_rocket(rockets);
            rocket_hit(rockets,enemies,enemies_number_1);
            rocket_hit(rockets,enemies2,enemies_number_2);
            rocket_hit(rockets,enemies3,enemies_number_3);
            rocket_hit(rockets,enemies4,enemies_number_4);
            rocket_hit(rockets,enemies5,enemies_number_5);
            rocket_hit(rockets,enemies6,enemies_number_6);
            
            move_pa_blasts(blasts);
            destroy_pa_blast(blasts);
            blast_hit(blasts,enemies,enemies_number_1);
            blast_hit(blasts,enemies2,enemies_number_2);
            blast_hit(blasts,enemies3,enemies_number_3);
            blast_hit(blasts,enemies4,enemies_number_4);
            blast_hit(blasts,enemies5,enemies_number_5);
            blast_hit(blasts,enemies6,enemies_number_6);
            
            move_enemy_rocket(rockets2,f,enemy_rockets_number);
            destroy_enemy_rocket(rockets2,enemy_rockets_number);
            rocket_hit(rockets2,f,enemy_rockets_number);
            
            move_enemy_rocket(rockets3,f,enemy_rockets_number2);
            destroy_enemy_rocket(rockets3,enemy_rockets_number2);
            rocket_hit(rockets3,f,enemy_rockets_number2);
            
            move_enemy_rocket(rockets4,f,enemy_rockets_number3);
            destroy_enemy_rocket(rockets4,enemy_rockets_number3);
            rocket_hit(rockets4,f,enemy_rockets_number3);
            
            weapon_collisions(rockets,rockets2,bullets,blasts,enemy_rockets_number);
            weapon_collisions(rockets,rockets3,bullets,blasts,enemy_rockets_number2);
            weapon_collisions(rockets,rockets4,bullets,blasts,enemy_rockets_number3);
            
            vehicles_collisions(enemies,f,enemies_number_1);
            vehicles_collisions(enemies2,f,enemies_number_2);
            vehicles_collisions(enemies3,f,enemies_number_3);
            vehicles_collisions(enemies4,f,enemies_number_4);
            vehicles_collisions(enemies5,f,enemies_number_5);
            vehicles_collisions(enemies6,f,enemies_number_6);
            
            for (int i= 0; i<8; i++){enemies[i].move(2);}
            for (int i= 0; i<16; i++){enemies2[i].move(2);}
            for (int i= 0; i<30; i++){enemies3[i].move_2(2,3);}
            for (int i= 0; i<30; i++){enemies4[i].move_2(3,3);}
            for (int i= 0; i<20; i++){enemies5[i].move_2(2,3);}
            for (int i= 0; i<7; i++){enemies6[i].move_3(2,1);}
            end_lev_stats(pp,f,1);
            end_game(f);
     }
     (*ptr)=99;
     display_level_2(f,enemies,enemies2,enemies3,enemies4,enemies5,enemies6,rockets,rockets2,rockets3,rockets4,bullets,blasts,waves,b,buf,enemies_number_1,enemies_number_2,enemies_number_3,enemies_number_4,enemies_number_5,enemies_number_6,pa_rockets_number,enemy_rockets_number,enemy_rockets_number2,enemy_rockets_number3,pa_bullets_number,pa_blasts_number);
     (*ptr)=0;
     
     delete [] enemies;
     delete [] enemies2;
     delete [] enemies3;
     delete [] enemies4;
     delete [] enemies5;
     delete [] enemies6;
     delete [] rockets;
     delete [] rockets2;
     delete [] rockets3;
     delete [] rockets4;
     delete [] bullets;
     delete [] blasts;
     for (int i = 0 ; i<20; i++){destroy_bitmap(b[i]);}                  
}

void display_isles(BITMAP *bb, BITMAP *b[]){
     static int i = 0;
     masked_blit(b[9],bb,0,0,100,300+i,b[9]->w,b[9]->h);
     masked_blit(b[10],bb,0,0,320,-500+i,b[10]->w,b[10]->h);
     masked_blit(b[11],bb,0,0,210,0+i,b[11]->w,b[11]->h);
     masked_blit(b[12],bb,0,0,70,-200+i,b[12]->w,b[12]->h);
     masked_blit(b[13],bb,0,0,150,-800+i,b[13]->w,b[13]->h);
     masked_blit(b[14],bb,0,0,200,-1100+i,b[14]->w,b[14]->h);
     masked_blit(b[15],bb,0,0,90,-1500+i,b[15]->w,b[15]->h);
     masked_blit(b[9],bb,0,0,20,-1800+i,b[9]->w,b[9]->h);
     masked_blit(b[11],bb,0,0,200,-2000+i,b[11]->w,b[11]->h);
     masked_blit(b[12],bb,0,0,280,-2180+i,b[12]->w,b[12]->h);
     masked_blit(b[13],bb,0,0,80,-2400+i,b[13]->w,b[13]->h);
     masked_blit(b[14],bb,0,0,130,-2600+i,b[14]->w,b[14]->h);
     masked_blit(b[12],bb,0,0,200,-2800+i,b[12]->w,b[12]->h);
     masked_blit(b[11],bb,0,0,120,-3000+i,b[11]->w,b[11]->h);
     i++;
     if (stop == 99) {i=0;}       
}

void credits(){
     clear_disp();
     while (!key[KEY_ENTER]){
           textprintf(screen,font,50,200,makecol(255,255,255),"PROGRAMMING AND GRAPHICS: Piotr Mierzwa"); 
           textprintf(screen,font,50,220,makecol(255,255,255),"GAME TESTING:             Piotr Mierzwa");
           textprintf(screen,font,50,240,makecol(255,255,255),"                          Pawel Mierzwa");
           textprintf(screen,font,50,270,makecol(255,255,255),"Press ENTER to continue");     
     }
     rest(200);      
}

void end_game(Fighter *f){
    if (f->return_progress()==3099){                                     
     BITMAP *medal = load_bmp("data/medal_of_piwin.bmp",default_palette);
     rectfill(screen,100,100,540,380,makecol(0,0,0));                              
     for (int i = 0; i<5; i++){
       rect(screen,100+i,100+i,540-i,380-i,makecol(0,0,200));
       masked_blit(medal,screen,0,0,260,120,medal->w,medal->h);
       textprintf(screen,font,130,250,makecol(255,255,255),"Congratulations! You receive Medal of Piwin!");
       textprintf(screen,font,130,270,makecol(255,255,255),"          Thank you for playing!");
       textprintf(screen,font,130,290,makecol(255,255,255),"         Press ENTER to continue");
     }
     while (!key[KEY_ENTER]){
     }
     rest(200); 
    }      
}     
                                    
                  
/////////////////////////
    
/*****************************MAIN***********************************/

int main() {
	init();
    install_int_ex(inc_speed,BPS_TO_TIMER(100));
    Player p;
    Player bests[5];
    load_best(bests);
            
	menu(p,ptr,bests);
	
	deinit();
	return 0;
}
END_OF_MAIN();



