// Author: Hannes Pabst

#include "grid_canvas.h"
#include <allegro.h>

namespace
{
	int const colors[8] = {8, 9, 12, 13, 6, 11, 14, 10};
}

void GridCanvas::clearScreen()
{
	clear_bitmap(screen);
}

void GridCanvas::drawTile(int const color, int const x, int const y)
{
	rectfill(screen, x * TX, y * TY, x * TX + TX - 2, y * TY + TY - 2, colors[color]);
}

void GridCanvas::drawText(char const * const text, int const x, int const y)
{
	textout_ex(screen, font, text, x * TX, y * TY, 7, 0);
}
