// Author: Hannes Pabst

#ifndef AI_VIEWER_H
#define AI_VIEWER_H

#include "ai_player.h"
#include "version.h"

class AiViewer
{
public:
	static int const FRAMES_PER_SECOND = 20;
	static int const PAGES_NUM = 9;

	AiViewer(AiPlayer const &aiPlayer);

	void setPage(int page);
	void scrollUp();
	void scrollDown();

	void invalidate();
	void paint();

	int getPage() const;

private:
	AiPlayer const *aiPlayer;
	int page;
	int	scrollPages[PAGES_NUM];
	bool clear;

	static int const scrollPagesMax[PAGES_NUM];
};


inline int AiViewer::getPage() const
{
	return page;
}

#endif
