// Author: Hannes Pabst

#ifndef AI_PLAYER_H
#define AI_PLAYER_H

#include "tetris_base.h"
#include "simple_tile.h"
#include "mt_random_number.h"
#include "no_piece_counter.h"
#include "no_dirty_field.h"
#include "block_histograms.h"
#include "field_histograms.h"

class AiPlayerBaseImpl
	: public TetrisBase<AiPlayerBaseImpl, SimpleTile, NoDirtyField>
{
public:
	typedef NoPieceCounter PieceCounter;
	typedef MtRandomNumber RandomNumber;

	AiPlayerBaseImpl()
		: TetrisBase<AiPlayerBaseImpl, SimpleTile, NoDirtyField>(0)
	{
	}

	RandomNumber &getRandomNumber() { return randomNumber; }
	PieceCounter &getPieceCounter() { return pieceCounter; }
  	DirtyState &getDirtyState() { return dirtyState; }

private:
	RandomNumber randomNumber;
	PieceCounter pieceCounter;
	DirtyState dirtyState;
};

class AiPlayer
	: private AiPlayerBaseImpl
{
public:
	typedef AiPlayerBaseImpl Base;

	struct Histograms
		: BlockHistograms
		, FieldHistograms<Base::PlayField>
	{
	};

	AiPlayer();

	void start();
	void execute(int frames);

	void setFullSpeed(bool fullSpeed);
	void resetFullSpeedMeasure();

	unsigned long getSeed() const;
	Histograms const &getHistograms() const;
	double getBlocks() const;
	double getBlocksPerFrame() const;
	bool isFullSpeed() const;

	using Base::getNextField;
	using Base::getPlayField;

private:
	Histograms histograms;
	unsigned long seed;
	double blocks;
	double fullSpeedBlocks;
	double fullSpeedFrames;
	bool fullSpeed;
};

void saveToFile(AiPlayer const &aiPlayer);


inline unsigned long AiPlayer::getSeed() const
{
	return seed;
}

inline AiPlayer::Histograms const &AiPlayer::getHistograms() const
{
	return histograms;
}

inline double AiPlayer::getBlocks() const
{
	return blocks;
}

inline double AiPlayer::getBlocksPerFrame() const
{
	return fullSpeedBlocks / fullSpeedFrames;
}

inline bool AiPlayer::isFullSpeed() const
{
	return fullSpeed;
}

#endif
