#include "sound_player.h"

SoundPlayer::SoundPlayer(Data data)
: data(data)
{
}

void SoundPlayer::sound(Tetris const &tetris, Tetris::Base::Event const event, bool const normalGameSpeed)
{
	switch (event)
	{
	case Tetris::Base::NEW_BLOCK:
		if (tetris.getResult().blocks == 0 && normalGameSpeed)
			play_sample(data.getGameStartedSound(), 255, 128, 1000, 0);
		break;
	case Tetris::Base::BLOCK_FIXED:
		if (normalGameSpeed)
			play_sample(data.getBlockFixedSound(), 255, 128, 1000, 0);
		break;
	case Tetris::Base::LINE_CLEARED:
		if (normalGameSpeed)
			play_sample(data.getLineClearedSound(), 255, 128, 1000, 0);
		break;
	case Tetris::Base::GAME_ENDED:
		play_sample(data.getGameEndedSound(), 255, 128, 1000, 0);
		break;
    default:
        break;
	}
}
