// Author: Hannes Pabst

#include "screenshot_saver.h"
#include "bit_array.h"
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include <limits.h>

#define FILE_EXTENSION ".pcx"
#define FILE_NAME_FORMAT "%02u" FILE_EXTENSION

namespace
{
	int const FILES_MAX = 100;
}

ScreenshotSaver::ScreenshotSaver(char const * const dir)
: dir(dir)
, filesNum(get_config_int(NULL, "screenshots_max", 10))
{
	if (filesNum < 0)
		filesNum = 0;
	else if (filesNum > FILES_MAX)
		filesNum = FILES_MAX;
}

void ScreenshotSaver::save(BITMAP * const buffer)
{
	if (filesNum > 0)
	{
		BitArray<FILES_MAX> foundIds;
		int foundNum = 0;
		sprintf(path, "%s\\*" FILE_EXTENSION, dir);
		_finddata_t findData;
		intptr_t const hFile = _findfirst(path, &findData);
		if (hFile != -1L)
		{
			do
			{
				unsigned int fileId;
				if (sscanf(findData.name, "%u", &fileId) == 1 && fileId < static_cast<unsigned int>(filesNum))
				{
					sprintf(path, FILE_NAME_FORMAT, fileId);
					if (strcmp(findData.name, path) == 0)
					{
						foundIds.set(fileId);
						++foundNum;
					}
				}
			}
			while (_findnext(hFile, &findData) == 0 && foundNum < filesNum);
			_findclose(hFile);
		}
		unsigned int id;
		if (foundNum < filesNum)
		{
			id = 0;
			while (foundIds.get(id))
				++id;
		}
		else
			id = filesNum - 1;
		sprintf(path, "%s\\" FILE_NAME_FORMAT, dir, id);
		PALLETE pallete;
		get_pallete(pallete);
		save_pcx(path, buffer, pallete);
	}
}
