// Author: Hannes Pabst

#ifndef CANVAS_H
#define CANVAS_H

#include "renderer.h"
#include <allegro.h>

class ScreenCanvas
	: public Renderer::Canvas
{
public:
	ScreenCanvas();
	~ScreenCanvas();

	bool isGood() const;
	bool isPageFlipping() const;
	bool isWaitingForVsync() const;
	void acquire() const;
	void release() const;
	void show(bool syncRefresh);

	BITMAP *getBuffer();
	void setDirty(int x, int y, int w, int h);

private:
	struct Rect
	{
		int x, y, w, h;
	};

	BITMAP *screen, *buffer;
	bool waitForVsync;
	int dirtyRectsNum;
	Rect dirtyRects[DIRTY_RECTS_MAX];

	// no copy
	ScreenCanvas(ScreenCanvas const &);
	ScreenCanvas &operator=(ScreenCanvas const &);
};

inline bool ScreenCanvas::isWaitingForVsync() const
{
	return waitForVsync;
}

#endif
