// Author: Hannes Pabst

#ifndef RENDERER_H
#define RENDERER_H

#include "game.h"
#include "data.h"

class Renderer
{
public:
	static int const SCREEN_WIDTH = 640;
	static int const SCREEN_HEIGHT = 480;
	static int const TEXT_BUFFER_SIZE = 35;

	struct Canvas
	{
		static int const DIRTY_RECTS_MAX = 6;

		virtual BITMAP *getBuffer() = 0;
		virtual void setDirty(int x, int y, int w, int h) = 0;
	};

	Renderer(Game const &game, Game::DirtyState &dirtyState, Canvas &canvas, Data data, char *textBuffer);

	void paint();

private:
	Game const &game;
	Game::DirtyState &dirtyState;
	Canvas &canvas;
	Data data;
	char *textBuffer;
	BITMAP *graphicBuffer;

	void paintTile(int x, int y, Tile tile) const;
	template <typename Field>
	void paintField(int fieldX, int fieldY, Field const &field, Rect const &dirty, bool repaint) const;
	void paintTetris() const;
	void drawMenuText(char const *text, int x, int y, bool selected) const;
	void drawTableLine(int row, Table::Info const &info, bool selected, bool cursorBlink) const;
	void paintTable() const;
	void paintMenu() const;

	// no copy
	Renderer(Renderer const &);
	Renderer &operator=(Renderer const &);
};

#endif
