// Author: Hannes Pabst

#ifndef MENU_H
#define MENU_H

#include "dirty_flag.h"

class Menu
{
public:
	enum Selection { PLAY, DEMO, TOP_SCORES };

	typedef DirtyFlag DirtyState;

	Menu(DirtyState &dirtyState);

	void setSelection(Selection selection);
	Selection getSelection() const;

private:
	DirtyState &dirtyState;
	Selection selection;

	// no copy
	Menu(Menu const &);
	Menu &operator=(Menu const &);
};


inline Menu::Selection Menu::getSelection() const
{
	return selection;
}

#endif
