// Author: Hannes Pabst

#ifndef GAME_H
#define GAME_H

#include "tetris.h"
#include "table.h"
#include "menu.h"

class Game
{
public:
	enum KeyEvent { KEY, QUIT, UP, DOWN, SELECT };
	enum Screen { TETRIS, TABLE, MENU };

	struct DirtyState
	{
		DirtyFlag screen;
		Tetris::DirtyState tetris;
		Table::DirtyState table;
		Menu::DirtyState menu;

		void invalidate();
		void validate();
	};

	Game(DirtyState &dirtyState, Tetris::SoundPlayer &soundPlayer, Tetris::Input &input, char const *tempFile, char const *tableDir);

	bool handleKeyEvent(KeyEvent keyEvent, char charCode);

	void execute();

	Tetris const &getTetris() const { return tetris; }
	Table const &getTable() const { return table; }
	Menu const &getMenu() const { return menu; }
	Screen getScreen() const { return screen; }

private:
	DirtyState &dirtyState;
	Tetris tetris;
	Table table;
	Menu menu;
	Screen screen;
	int cursorTimer;

	void setScreen(Screen screen);
	void setMenu();

	// no copy
	Game(Game const &);
	Game &operator=(Game const &);
};

char checkCharCode(char charCode, char defaultCharCode);

#endif
