// Author: Hannes Pabst

#ifndef DIRTY_FLAG_H
#define DIRTY_FLAG_H

class DirtyFlag
{
public:
	static int const INVALID = 1 << 0;

	DirtyFlag();

	void invalidate();
	void validate();

	int add(int dirtyState);
	int get() const;

private:
	int dirtyState;
};


inline DirtyFlag::DirtyFlag()
: dirtyState(INVALID)
{
}

inline void DirtyFlag::invalidate()
{
	dirtyState = -1;
}

inline void DirtyFlag::validate()
{
	dirtyState = 0;
}

inline int DirtyFlag::add(int const dirtyState)
{
	return this->dirtyState |= dirtyState;
}

inline int DirtyFlag::get() const
{
	return dirtyState;
}

#endif
