// Author: Hannes Pabst

#ifndef DATA_FILE_OWNER_H
#define DATA_FILE_OWNER_H

#include <allegro.h>

class DataFileOwner
{
public:
	DataFileOwner(char const *datFileName);
	~DataFileOwner();

	DATAFILE const *getDatafile() const;

private:
	DATAFILE *datafile;

	// no copy
	DataFileOwner(DataFileOwner const &);
	DataFileOwner &operator=(DataFileOwner const &);
};


inline DataFileOwner::DataFileOwner(char const * const datFileName)
: datafile(load_datafile(datFileName))
{
}

inline DataFileOwner::~DataFileOwner()
{
	if (datafile != NULL)
		unload_datafile(datafile);
}

DATAFILE const *DataFileOwner::getDatafile() const
{
	return datafile;
}

#endif
