// Author: Hannes Pabst

#ifndef DATA_H
#define DATA_H

#include "dat.h"
#include <allegro.h>

class Data
{
public:
	Data(DATAFILE const &dataFile);

	BITMAP *getGameBackground() const;
	BITMAP *getTextBackground() const;
	BITMAP *getTitleBackground() const;
	BITMAP *getTiles() const;
	FONT const *getFont() const;
	FONT const *getTitleText() const;
	SAMPLE const *getGameStartedSound() const;
	SAMPLE const *getBlockFixedSound() const;
	SAMPLE const *getLineClearedSound() const;
	SAMPLE const *getGameEndedSound() const;
	int getNormalTextColor() const;
	int getHeadingTextColor() const;
	int getSelectionFrameColor() const;
	int getSelectionBarColor() const;

private:
	DATAFILE const *dataFile;

	template<typename DataType>
	DataType *get(int id) const;

	int getColor(int id) const;
};

inline Data::Data(DATAFILE const &dataFile)
: dataFile(&dataFile)
{
}

template<typename DataType>
inline DataType *Data::get(int id) const
{
	return static_cast<DataType *>(dataFile[id].dat);
}

inline BITMAP *Data::getGameBackground() const
{
	return get<BITMAP>(GAMEBACK_PCX);
}

inline BITMAP *Data::getTextBackground() const
{
	return get<BITMAP>(TEXTBACK_PCX);
}

inline BITMAP *Data::getTitleBackground() const
{
	return get<BITMAP>(TITLEBACK_PCX);
}

inline BITMAP *Data::getTiles() const
{
	return get<BITMAP>(TILES_PCX);
}

inline FONT const *Data::getFont() const
{
	return get<FONT>(FONT_PCX);
}

inline FONT const *Data::getTitleText() const
{
	return get<FONT>(TETRIS_PCX);
}

inline SAMPLE const *Data::getGameStartedSound() const
{
	return get<SAMPLE>(GAMESTARTED_WAV);
}

inline SAMPLE const *Data::getBlockFixedSound() const
{
	return get<SAMPLE>(BLOCKFIXED_WAV);
}

inline SAMPLE const *Data::getLineClearedSound() const
{
	return get<SAMPLE>(LINECLEARED_WAV);
}

inline SAMPLE const *Data::getGameEndedSound() const
{
	return get<SAMPLE>(GAMEENDED_WAV);
}

inline int Data::getColor(int id) const
{
	return getpixel(get<BITMAP>(COLORS_PCX), id, 0);
}

inline int Data::getNormalTextColor() const
{
	return getColor(0);
}

inline int Data::getHeadingTextColor() const
{
	return getColor(1);
}

inline int Data::getSelectionFrameColor() const
{
	return getColor(2);
}

inline int Data::getSelectionBarColor() const
{
	return getColor(3);
}

#endif
