#include "config_key.h"
#include <allegro.h>

ConfigKey::ConfigKey(char const * const name0, char const * const name1, int const defaultKeyCode)
: keyCode0(getConfigKey(name0, defaultKeyCode))
, keyCode1(getConfigKey(name1, keyCode0))
{
}

bool ConfigKey::state() const
{
	return key[keyCode0] != 0 || key[keyCode1] != 0;
}

int ConfigKey::getConfigKey(char const * const name, int const defaultKeyCode)
{
	return checkKey(get_config_int(NULL, name, defaultKeyCode), defaultKeyCode);
}

int ConfigKey::checkKey(int const keyCode, int const defaultKeyCode)
{
	if (keyCode >= 1 && keyCode < KEY_MAX)
		return keyCode;
	return defaultKeyCode;
}
