// Author: Hannes Pabst

#ifndef BIT_ARRAY_H
#define BIT_ARRAY_H

#include <memory.h>

template <int SIZE>
class BitArray
{
public:
	BitArray();

	void set(int idx);
	void clear(int idx);

	bool get(int idx) const;

private:
	char a[(SIZE + 7) >> 3];
};

template <int SIZE>
inline BitArray<SIZE>::BitArray()
//: a() // MSVC 2003 bug
{
	memset(a, 0, sizeof a);
}

template <int SIZE>
inline void BitArray<SIZE>::set(int const idx)
{
	a[idx >> 3] |= 1 << (idx & 7);
}

template <int SIZE>
inline void BitArray<SIZE>::clear(int const idx)
{
	a[idx >> 3] &= ~(1 << (idx & 7));
}


template <int SIZE>
inline bool BitArray<SIZE>::get(int const idx) const
{
	return (a[idx >> 3] & 1 << (idx & 7)) != 0;
}

#endif
