// Author: Hannes Pabst

#include "system.h"
#include <windows.h>

Event::Event()
{
	event = CreateEvent(NULL, FALSE, FALSE, NULL);
}

Event::~Event()
{
	if (event != NULL)
		CloseHandle(event);
}

void Event::set()
{
	if (event != NULL)
		SetEvent(event);
}

void Event::wait()
{
	if (event != NULL)
		WaitForSingleObject(event, INFINITE);
}

Flag::Flag(bool const value)
: value(value)
{
}

bool Flag::set(bool const value)
{
	return InterlockedExchange(&this->value, value) != 0;
}
