// Author: Hannes Pabst

#ifndef COLOR_H
#define COLOR_H

namespace Color
{
	class Rgb
	{
	public:
		double r, g, b;

		Rgb(double r, double g, double b);
		Rgb(double h);
	};

	double hue(Rgb const &rgb);

	class Hsl
	{
	public:
		double h, s, l;

		Hsl(double h, double s, double l);
		Hsl(Rgb const &rgb);

		operator Rgb() const;

	private:
		double rgbComponent(double c) const;
	};

	class Hsv
	{
	public:
		double h, s, v;

		Hsv(double h, double s, double v);
		Hsv(Rgb const &rgb);

		operator Rgb() const;

	private:
		double rgbComponent(double c) const;
	};


	inline Rgb::Rgb(double const r, double const g, double const b)
		: r(r), g(g), b(b)
	{
	}

	inline Hsl::Hsl(double const h, double const s, double const l)
		: h(h), s(s), l(l)
	{
	}

	inline Hsv::Hsv(double const h, double const s, double const v)
		: h(h), s(s), v(v)
	{
	}
}

#endif
