// Author: Hannes Pabst

#ifndef TILE_H
#define TILE_H

#include "block_edges.h"

class Tile
{
public:
	Tile();

	void set(int block, int tile);
	void flash(int block);
	void addEdge(int edge);

	void blank();
	bool isBlank() const;

	int getBlock() const;
	int getColor() const;
	int getEdge() const;

	static bool isCutEdgesEnabled();

private:
	char block;
	char edge;
};


inline Tile::Tile()
: block(0)
, edge(-1)
{
}

inline void Tile::set(int const block, int const tile)
{
	this->block = static_cast<char>(block);
	edge = char(BlockEdges::getTileEdge(block, tile));
}

inline void Tile::flash(int const block)
{
	this->block = static_cast<char>(block);
	edge = BlockEdges::EDGE_L_T_R_B;
}

inline void Tile::addEdge(int const edge)
{
	this->edge |= edge;
}

inline void Tile::blank()
{
	edge = -1;
}

inline bool Tile::isBlank() const
{
	return edge < 0;
}

inline int Tile::getBlock() const
{
	return block;
}

inline int Tile::getColor() const
{
	return isBlank() ? 0 : Block::align(block) + 1;
}

inline int Tile::getEdge() const
{
	return edge;
}

inline bool Tile::isCutEdgesEnabled()
{
	return true;
}

#endif
