// Author: Hannes Pabst

#ifndef STATISTIC_H
#define STATISTIC_H

#include "array.h"
#include "min_max.h"

class Statistic
{
public:
	struct Entry
	{
		double frequency;
		double percent;
		double cumulativePercent;
	};

	template <int size>
	struct Buffer
		: Array<Entry, size>
	{
	};

	double total;
	double maximum;
	double mean;
	double variance;

	ArrayRef<Entry> frequencyTable;

	template <int sizeFrequencies, int sizeBuffer>
	Statistic(Array<double, sizeFrequencies> const &frequencies, Buffer<sizeBuffer> &buffer);

private:
	void calculateStatistics(ArrayRef<double const> frequencies);
};


template <int sizeFrequencies, int sizeBuffer>
inline Statistic::Statistic(Array<double, sizeFrequencies> const &frequencies, Buffer<sizeBuffer> &buffer)
: frequencyTable(ArrayRef<Entry>(&buffer[0], min(sizeFrequencies, sizeBuffer)))
{
	calculateStatistics(frequencies);
}

#endif
