// Author: Hannes Pabst

#include "statistic.h"
#include <limits>

namespace
{
	double percent(double const frequency, double const total)
	{
		return frequency * 100 / total;
	}
}

void Statistic::calculateStatistics(ArrayRef<double const> const frequencies)
{
	int maxValue = -1;
	for (int value = frequencyTable.getSize() - 1; value >= 0; --value)
		if (frequencies[value] != 0)
		{
			maxValue = value;
			break;
		}

	total = 0;
	if (maxValue >= 0)
	{
		for (int value = maxValue; value >= 0; --value)
			total += frequencies[value];

		maximum = maxValue;

		mean = 0;
		for (int value = maxValue; value >= 0; --value)
			mean += value * frequencies[value];
		mean /= total;

		variance = 0;
		for (int value = maxValue; value >= 0; --value)
		{
			double const delta = value - mean;
			variance += delta * delta * frequencies[value];
		}
		variance /= total;

		double cumulativeFrequency = total;
		for (int value = frequencyTable.getSize() - 1; value >= 0; --value)
		{
			Entry &entry = frequencyTable[value];
			entry.frequency = frequencies[value];
			entry.percent = percent(entry.frequency, total);
			entry.cumulativePercent = percent(cumulativeFrequency, total);
			cumulativeFrequency -= entry.frequency;
		}
	}
	else
	{
		maximum = mean = variance = 0;
		for (int value = frequencyTable.getSize() - 1; value >= 0; --value)
		{
			Entry &entry = frequencyTable[value];
			entry.frequency = entry.percent = entry.cumulativePercent = 0;
		}
	}
}
