// Author: Hannes Pabst

#ifndef SIMPLE_TILE_H
#define SIMPLE_TILE_H

#include "block_edges.h"

class SimpleTile
{
public:
	SimpleTile();

	void set(int block, int);
	void flash(int block);
	void addEdge(int);

	void blank();
	bool isBlank() const;

	int getColor() const;
	int getEdge() const;

	static bool isCutEdgesEnabled();

private:
	char value;
};


inline SimpleTile::SimpleTile()
: value(-1)
{
}

inline void SimpleTile::set(int const block, int)
{
	value = static_cast<char>(block);
}

inline void SimpleTile::flash(int const block)
{
	value = static_cast<char>(block);
}

inline void SimpleTile::addEdge(int)
{
}

inline void SimpleTile::blank()
{
	value = -1;
}

inline bool SimpleTile::isBlank() const
{
	return value < 0;
}

inline int SimpleTile::getColor() const
{
	return isBlank() ? 0 : Block::align(value) + 1;
}

inline int SimpleTile::getEdge() const
{
	return BlockEdges::EDGE_L_T_R_B;
}

inline bool SimpleTile::isCutEdgesEnabled()
{
	return false;
}

#endif
