// Author: Hannes Pabst

#ifndef RECT_H
#define RECT_H

#include "point.h"

struct Rect
{
	Point leftTop, rightBottom;

	Rect(Point const &leftTop, Point const &rightBottom);
};

Rect operator +(Rect const &rect, Point const &point);
Rect invert(Rect const &rect);
Rect bound(Rect const &rect0, Rect const &rect1);
bool contains(Rect const &rect0, Rect const &rect1);


inline Rect::Rect(Point const &leftTop, Point const &rightBottom)
: leftTop(leftTop)
, rightBottom(rightBottom)
{
}

inline Rect operator +(Rect const &rect, Point const &point)
{
	return Rect(rect.leftTop + point, rect.rightBottom + point);
}

inline Rect invert(Rect const &rect)
{
	return Rect(rect.rightBottom, rect.leftTop);
}

inline Rect bound(Rect const &rect0, Rect const &rect1)
{
	return Rect(leftTop(rect0.leftTop, rect1.leftTop), rightBottom(rect0.rightBottom, rect1.rightBottom));
}

inline bool contains(Rect const &rect0, Rect const &rect1)
{
	return isLeftTop(rect0.leftTop, rect1.leftTop) && isRightBottom(rect0.rightBottom, rect1.rightBottom);
}

#endif
