// Author: Hannes Pabst

#ifndef RANDOM_NUMBER_H
#define RANDOM_NUMBER_H

class RandomNumber
{
public:
	static long const RANDOM_MAX = 0x7fff;

	RandomNumber(long seed = -1L);

	operator long();

	long next();
	long next(long max);

private:
	long seed;
};


inline RandomNumber::RandomNumber(long const seed)
: seed(seed)
{
}

inline RandomNumber::operator long()
{
	return seed;
}

inline long RandomNumber::next()
{
	return ((seed = seed * 214013L + 2531011L) >> 16) & RANDOM_MAX;
}

inline long RandomNumber::next(long const max)
{
	return next() % (max + 1);
}

#endif
