// Author: Hannes Pabst

#ifndef POINT_H
#define POINT_H

#include "min_max.h"

struct Point
{
	int x, y;

	Point(int x, int y);
};

Point operator +(Point const &point0, Point const &point1);
Point leftTop(Point const &point0, Point const &point1);
Point rightBottom(Point const &point0, Point const &point1);
bool isLeftTop(Point const &point0, Point const &point1);
bool isRightBottom(Point const &point0, Point const &point1);


inline Point::Point(int const x, int const y)
: x(x)
, y(y)
{
}

inline Point operator +(Point const &point0, Point const &point1)
{
	return Point(point0.x + point1.x, point0.y + point1.y);
}

inline Point leftTop(Point const &point0, Point const &point1)
{
	return Point(min(point0.x, point1.x), min(point0.y, point1.y));
}

inline Point rightBottom(Point const &point0, Point const &point1)
{
	return Point(max(point0.x, point1.x), max(point0.y, point1.y));
}

inline bool isLeftTop(Point const &point0, Point const &point1)
{
	return point0.x <= point1.x && point0.y <= point1.y;
}

inline bool isRightBottom(Point const &point0, Point const &point1)
{
	return point0.x >= point1.x && point0.y >= point1.y;
}

#endif
