// Author: Hannes Pabst

#ifndef PIECE_FIELD_H
#define PIECE_FIELD_H

#include "piece.h"

int blockLeft(int block);

template <typename Field>
int blockRight(int block);

template <typename Field>
Rect getFieldBound();

template <typename Field>
void putPiece(Field &field, Piece const &piece);

template <typename Field>
void removePiece(Field &field, Piece const &piece);

template <typename Field>
bool canPutPiece(Field const &field, Piece const &piece);


__forceinline int blockLeft(int const block)
{
	return - Block::getBoundLeft(block);
}

template <typename Field>
__forceinline int blockRight(int const block)
{
	return Field::WIDTH - 1 - Block::getBoundRight(block);
}

template <typename Field>
Rect getFieldBound()
{
	return Rect(Point(0, 0), Point(Field::WIDTH - 1, Field::HEIGHT - 1));
}

template <typename Field>
__forceinline void putPiece(Field &field, Piece const &piece)
{
	for (int tile = 0; tile < Block::TILE_NUM; ++tile)
		at(field, getTilePosition(piece, tile)).set(piece.block, tile);
}

template <typename Field>
__forceinline void removePiece(Field &field, Piece const &piece)
{
	for (int tile = 0; tile < Block::TILE_NUM; ++tile)
		at(field, getTilePosition(piece, tile)).blank();
}

template <typename Field>
bool canPutPiece(Field const &field, Piece const &piece)
{
	if (!contains(getFieldBound<Field>(), getBound(piece)))
		return false;
	for (int tile = 0; tile < Block::TILE_NUM; ++tile)
		if (!at(field, getTilePosition(piece, tile)).isBlank())
			return false;
	return true;
}

#endif
