// Author: Hannes Pabst

#ifndef PIECE_COUNTER_H
#define PIECE_COUNTER_H

template<int piecesMax>
class PieceCounter
{
public:
	void reset();
	void takePiece();
	bool hasMorePieces() const;

protected:
	int piecesLeft;
};


template<int piecesMax>
inline void PieceCounter<piecesMax>::reset()
{
	piecesLeft = piecesMax;
}

template<int piecesMax>
inline void PieceCounter<piecesMax>::takePiece()
{
	--piecesLeft;
}

template<int piecesMax>
inline bool PieceCounter<piecesMax>::hasMorePieces() const
{
	return piecesLeft > 0;
}

#endif
