// Author: Hannes Pabst

#ifndef PIECE_H
#define PIECE_H

#include "block.h"
#include "rect.h"

struct Piece
{
	int block;
	Point position;

	Piece(int block, Point const &position);
};

Rect getBound(int block);
Rect getBound(Piece const &piece);
Point getTilePosition(Piece const &piece, int tile);


inline Piece::Piece(int const block, Point const &position)
: block(block)
, position(position)
{
}

inline Rect getBound(int const block)
{
	return Rect(Point(Block::getBoundLeft(block), Block::getBoundTop(block)), Point(Block::getBoundRight(block), Block::getBoundBottom(block)));
}

inline Rect getBound(Piece const &piece)
{
	return getBound(piece.block) + piece.position;
}

inline Point getTilePosition(Piece const &piece, int const tile)
{
	return Block::getTilePosition(piece.block, tile) + piece.position;
}

#endif
