// Author: Hannes Pabst

#ifndef MT_RANDOM_NUMBER_H
#define MT_RANDOM_NUMBER_H

#include "mersenne_twister.h"

class MtRandomNumber
{
public:
	static void seed(long seed);
	static long timeSeed();

	static long next();
	static long next(long max);

private:
	static MTRand mtRand;
};


inline void MtRandomNumber::seed(long const seed)
{
	mtRand.seed(seed);
}

inline long MtRandomNumber::timeSeed()
{
	return MTRand::timeSeed();
}

inline long MtRandomNumber::next()
{
	return mtRand.randInt();
}

inline long MtRandomNumber::next(long const max)
{
	return mtRand.randInt(max);
}

#endif
