// Author: Hannes Pabst

#ifndef HP_EVALUATOR_SCORES_H
#define HP_EVALUATOR_SCORES_H

#include "evaluator_scores.h"

template <typename Field>
class HpEvaluatorScores
	: public EvaluatorScores<Field>
{
public:
	HpEvaluatorScores();
};


template <typename Field>
HpEvaluatorScores<Field>::HpEvaluatorScores()
{
    this->clearedLineScore = 13;
	this->gapsScore = 29;
	this->midScores[this->DELTA_OFFSET] = 0;
	this->borderScores[this->DELTA_OFFSET] = 0;
	for (int d = 1; d < this->DELTA_ABS_MAX; ++d)
	{
		int const dd = d * d * - 2;
		this->borderScores[this->DELTA_OFFSET - d] = dd;
		this->borderScores[this->DELTA_OFFSET + d] = dd + d * - 7;
		this->midScores[this->DELTA_OFFSET - d] = dd - 2;
		this->midScores[this->DELTA_OFFSET + d] = dd;
	}
}

#endif
