// Author: Hannes Pabst

#ifndef FIELD_TRANSITION_H
#define FIELD_TRANSITION_H

#include "field_info.h"
#include "piece.h"

template <typename Field>
class FieldTransition
{
public:
	FieldTransition(Field const &field, FieldInfo<Field> const &fieldInfo);

	void putPiece(Piece const &piece);
	FieldInfo<Field> const &getFieldInfo() const;
	bool willUseField() const;
	int getClearedLines() const;
	int getGaps() const;

private:
	Field const *field;
	FieldInfo<Field> fieldInfo;
	int clearedLines, gaps;
};


template <typename Field>
__forceinline FieldTransition<Field>::FieldTransition(Field const &field, FieldInfo<Field> const &fieldInfo)
: field(&field)
, fieldInfo(fieldInfo)
, clearedLines(0)
, gaps(0)
{
}

template <typename Field>
__forceinline void FieldTransition<Field>::putPiece(Piece const &piece)
{
	bool cleared = false;
	for (int tile = 0; tile < Block::TILE_NUM; ++tile)
	{
		Point const tilePosition = getTilePosition(piece, tile);
		gaps -=	fieldInfo.putTile(tilePosition.x, tilePosition.y);
		if (fieldInfo.getTileNum(tilePosition.y) == Field::WIDTH)
		{
			gaps += fieldInfo.clearFullLine(tilePosition.y, field);
			++clearedLines;
			cleared = true;
		}
	}
	if (cleared)
		field = 0;
}

template <typename Field>
__forceinline FieldInfo<Field> const &FieldTransition<Field>::getFieldInfo() const
{
	return fieldInfo;
}

template <typename Field>
__forceinline bool FieldTransition<Field>::willUseField() const
{
	return field != 0;
}

template <typename Field>
__forceinline int FieldTransition<Field>::getClearedLines() const
{
	return clearedLines;
}

template <typename Field>
__forceinline int FieldTransition<Field>::getGaps() const
{
	return gaps;
}

#endif
