// Author: Hannes Pabst

#ifndef FIELD_INFO_H
#define FIELD_INFO_H

#include "inline.h"

template <typename Field>
class FieldInfo
{
public:
	FieldInfo();

	int putTile(int x, int y);
	int clearFullLine(int lineY, Field const *field);

	int getTopTileY(int x) const;
	int getTileNum(int y) const;

private:
	char tileNums[Field::HEIGHT];
	char topTileYs[Field::WIDTH];
};

template<typename Field>
int clearFullLine(Field &field, FieldInfo<Field> &fieldInfo, int lineY);


template <typename Field>
FieldInfo<Field>::FieldInfo()
{
	for (int y = 0; y < Field::HEIGHT; ++y)
		tileNums[y] = 0;
	for (int x = 0; x < Field::WIDTH; ++x)
		topTileYs[x] = Field::HEIGHT;
}

template <typename Field>
__forceinline int FieldInfo<Field>::putTile(int const x, int const y)
{
	++tileNums[y];
	int gaps = -1;
	if (y < topTileYs[x])
	{
		gaps = topTileYs[x] - y - 1;
		topTileYs[x] = static_cast<char>(y);
	}
	return gaps;
}

template <typename Field>
__forceinline int FieldInfo<Field>::clearFullLine(int const lineY, Field const * const field)
{
	for (int y = lineY; y > 0; --y)
		tileNums[y] = tileNums[y - 1];
	tileNums[0] = 0;
	int gaps = 0;
	for (int x = 0; x < Field::WIDTH; ++x)
	{
		if (topTileYs[x]++ == lineY && field != 0)
			while (topTileYs[x] < Field::HEIGHT && field->at(x, topTileYs[x]).isBlank())
			{
				++topTileYs[x];
				++gaps;
			}
	}
	return gaps;
}

template <typename Field>
__forceinline int FieldInfo<Field>::getTopTileY(int const x) const
{
	return topTileYs[x];
}

template <typename Field>
__forceinline int FieldInfo<Field>::getTileNum(int const y) const
{
	return tileNums[y];
}

template<typename Field>
int clearFullLine(Field &field, FieldInfo<Field> &fieldInfo, int const lineY)
{
	int dirtyTop = Field::HEIGHT - 1;
	for (int x = 0; x < Field::WIDTH; ++x)
	{
		int const topTileY = fieldInfo.getTopTileY(x);
		for (int y = lineY; y > topTileY; --y)
			field.at(x, y) = field.at(x, y - 1);
		field.at(x, topTileY).blank();
		if (topTileY < dirtyTop)
			dirtyTop = topTileY;
	}
	fieldInfo.clearFullLine(lineY, &field);
	return dirtyTop;
}

#endif
