// Author: Hannes Pabst

#ifndef FIELD_H
#define FIELD_H

#include "array.h"
#include "point.h"

template <typename T, int width, int height>
class Field
{
public:
	static int const WIDTH = width;
	static int const HEIGHT = height;

	typedef T Elem;

	T &at(int x, int y);
	T const &at(int x, int y) const;

private:
	Array<Array<T, height>, width> field;
};

template <typename T, int width, int height>
T &at(Field<T, width, height> &field, Point const &position);

template <typename T, int width, int height>
T const &at(Field<T, width, height> const &field, Point const &position);


template <typename T, int width, int height>
inline T &Field<T, width, height>::at(int const x, int const y)
{
	return const_cast<T &>(const_cast<Field<T, width, height> const &>(*this).at(x, y));
}

template <typename T, int width, int height>
inline T const &Field<T, width, height>::at(int const x, int const y) const
{
	return field[x][y];
}

template <typename T, int width, int height>
inline T &at(Field<T, width, height> &field, Point const &position)
{
	return const_cast<T &>(at(const_cast<Field<T, width, height> const &>(field), position));
}

template <typename T, int width, int height>
inline T const &at(Field<T, width, height> const &field, Point const &position)
{
	return field.at(position.x, position.y);
}

#endif
