// Author: Hannes Pabst

#ifndef EVALUATOR_SCORES_H
#define EVALUATOR_SCORES_H

#include "inline.h"
#include <assert.h>

template <typename Field>
class EvaluatorScores
{
public:
	static int const DELTA_ABS_MAX = Field::HEIGHT + 1;

	int getClearedLineScore() const;
	int getGapsScore() const;
	int getBorderScore(int delta) const;
	int getMidScore(int delta) const;

protected:
	static int const DELTA_MAX = DELTA_ABS_MAX * 2 - 1;
	static int const DELTA_OFFSET = DELTA_ABS_MAX - 1;

	int clearedLineScore;
	int gapsScore;
	int borderScores[DELTA_MAX];
	int midScores[DELTA_MAX];

	EvaluatorScores();
};


template <typename Field>
inline EvaluatorScores<Field>::EvaluatorScores()
{
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getClearedLineScore() const
{
	return clearedLineScore;
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getGapsScore() const
{
	return gapsScore;
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getBorderScore(int const delta) const
{
	assert(delta > - DELTA_ABS_MAX && delta < DELTA_ABS_MAX);
	return borderScores[DELTA_OFFSET + delta];
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getMidScore(int const delta) const
{
	assert(delta > - DELTA_ABS_MAX && delta < DELTA_ABS_MAX);
	return midScores[DELTA_OFFSET + delta];
}

#endif
