// Author: Hannes Pabst

#ifndef EVALUATOR_SCORES_H
#define EVALUATOR_SCORES_H

#include "inline.h"
#include <assert.h>

template <typename Field>
class EvaluatorScores
{
public:
	EvaluatorScores();

	int getClearedLineScore() const;
	int getGapsScore() const;
	int getBorderScore(int delta) const;
	int getMidScore(int delta) const;

protected:
	static int const DELTA_ABS_MAX = Field::HEIGHT + 1;
	static int const DELTA_MAX = DELTA_ABS_MAX * 2 - 1;
	static int const DELTA_OFFSET = DELTA_ABS_MAX - 1;

	int clearedLineScore;
	int gapsScore;
	int borderScores[DELTA_MAX];
	int midScores[DELTA_MAX];
};


template <typename Field>
EvaluatorScores<Field>::EvaluatorScores()
: clearedLineScore(13)
, gapsScore(29)
{
	midScores[DELTA_OFFSET] = 0;
	borderScores[DELTA_OFFSET] = 0;
	for (int d = 1; d < DELTA_ABS_MAX; ++d)
	{
		int const dd = d * d * - 2;
		borderScores[DELTA_OFFSET - d] = dd;
		borderScores[DELTA_OFFSET + d] = dd + d * - 7;
		midScores[DELTA_OFFSET - d] = dd - 2;
		midScores[DELTA_OFFSET + d] = dd;
	}
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getClearedLineScore() const
{
	return clearedLineScore;
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getGapsScore() const
{
	return gapsScore;
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getBorderScore(int const delta) const
{
	assert(delta > - DELTA_ABS_MAX && delta < DELTA_ABS_MAX);
	return borderScores[DELTA_OFFSET + delta];
}

template <typename Field>
__forceinline int EvaluatorScores<Field>::getMidScore(int const delta) const
{
	assert(delta > - DELTA_ABS_MAX && delta < DELTA_ABS_MAX);
	return midScores[DELTA_OFFSET + delta];
}

#endif
