// Author: Hannes Pabst

#ifndef DIRTY_FIELD_H
#define DIRTY_FIELD_H

#include "piece_field.h"

template <typename Field>
class DirtyField
{
public:
	DirtyField();

	void addRect(Rect const &rect);
	void invalidate();
	void validate();

	Rect getDirtyRect() const;

private:
	Rect dirtyRect;
};


template <typename Field>
DirtyField<Field>::DirtyField()
: dirtyRect(getFieldBound<Field>())
{
}

template <typename Field>
void DirtyField<Field>::addRect(Rect const &rect)
{
	dirtyRect = bound(dirtyRect, rect);
}

template <typename Field>
void DirtyField<Field>::invalidate()
{
	dirtyRect = getFieldBound<Field>();
}

template <typename Field>
void DirtyField<Field>::validate()
{
	dirtyRect = invert(getFieldBound<Field>());
}

template <typename Field>
inline Rect DirtyField<Field>::getDirtyRect() const
{
	return dirtyRect;
}

#endif
