// Author: Hannes Pabst

#ifndef BLOCK_HISTOGRAMS_H
#define BLOCK_HISTOGRAMS_H

#include "block.h"
#include "frequency_array.h"

class BlockHistograms
{
public:
	typedef FrequencyArray<Block::BLOCK_TOTAL_NUM> BlockFrequencies;
	typedef FrequencyArray<Block::BLOCK_ALIGNED_NUM> AlignedBlockFrequencies;
	typedef FrequencyArray<Block::BLOCK_HEIGHT_MAX + 1> ClearFrequencies;
	typedef FrequencyArray<Block::ROTATE_CYCLE_MAX> RotationsFrequencies;

	void addBlock(int block, int clearedLines);

	BlockFrequencies const &getBlockFrequencies() const;
	AlignedBlockFrequencies const &getAlignedBlockFrequencies() const;
	ClearFrequencies const &getClearFrequencies() const;

	int calculateRotationsFrequencies(RotationsFrequencies &rotationsFrequencies, int block) const;

private:
	BlockFrequencies blockFrequencies;
	AlignedBlockFrequencies alignedBlockFrequencies;
	ClearFrequencies clearFrequencies;
};


inline BlockHistograms::BlockFrequencies const &BlockHistograms::getBlockFrequencies() const
{
	return blockFrequencies;
}

inline BlockHistograms::AlignedBlockFrequencies const &BlockHistograms::getAlignedBlockFrequencies() const
{
	return alignedBlockFrequencies;
}

inline BlockHistograms::ClearFrequencies const &BlockHistograms::getClearFrequencies() const
{
	return clearFrequencies;
}

#endif
