// Author: Hannes Pabst

#include "block_histograms.h"

void BlockHistograms::addBlock(int const block, int const clearedLines)
{
	++blockFrequencies[block];
	++alignedBlockFrequencies[Block::align(block)];
	++clearFrequencies[clearedLines];
}

int BlockHistograms::calculateRotationsFrequencies(RotationsFrequencies &rotationsFrequencies, int const block) const
{
	int rotatedBlock = block;
	int rotationCount = 0;
	do
	{
		rotationsFrequencies[rotationCount++] = blockFrequencies[rotatedBlock];
		rotatedBlock = Block::rotate(rotatedBlock);
	}
	while (rotatedBlock != block);
	return rotationCount;
}
