// Author: Hannes Pabst

#ifndef BLOCK_EDGES_H
#define BLOCK_EDGES_H

#include "block.h"

class BlockEdges
{
public:
	static int const TOTAL_NUM = 16;

	static int const EDGE_L = 1 << 0;
	static int const EDGE_T = 1 << 1;
	static int const EDGE_R = 1 << 2;
	static int const EDGE_B = 1 << 3;
	static int const EDGE_L_T = EDGE_L | EDGE_T;
	static int const EDGE_L_R = EDGE_L | EDGE_R;
	static int const EDGE_T_R = EDGE_T | EDGE_R;
	static int const EDGE_L_T_R = EDGE_L | EDGE_T | EDGE_R;
	static int const EDGE_L_B = EDGE_L | EDGE_B;
	static int const EDGE_T_B = EDGE_T | EDGE_B;
	static int const EDGE_L_T_B = EDGE_L | EDGE_T | EDGE_B;
	static int const EDGE_R_B = EDGE_R | EDGE_B;
	static int const EDGE_L_R_B = EDGE_L | EDGE_R | EDGE_B;
	static int const EDGE_T_R_B = EDGE_T | EDGE_R | EDGE_B;
	static int const EDGE_L_T_R_B = EDGE_L | EDGE_T | EDGE_R | EDGE_B;

	static int getTileEdge(int block, int tile);

private:
	static int const edges[Block::BLOCK_TOTAL_NUM][Block::TILE_NUM];
};


inline int BlockEdges::getTileEdge(int const block, int tile)
{
	return edges[block][tile];
}

#endif
