// Author: Hannes Pabst

#ifndef BLOCK_H
#define BLOCK_H

#include "point.h"

class Block
{
public:
	static int const BLOCK_TOTAL_NUM = 19;
	static int const BLOCK_ALIGNED_NUM = 7;
	static int const TILE_NUM = 4;

	static int const BLOCK_ALIGNED_WIDTH_MAX = TILE_NUM;
	static int const BLOCK_ALIGNED_HEIGHT_MAX = 2;
	static int const BLOCK_WIDTH_MAX = TILE_NUM;
	static int const BLOCK_HEIGHT_MAX = TILE_NUM;
	static int const ROTATE_CYCLE_MAX = 4;

	static Point const &getTilePosition(int block, int tile);

	static int getBoundLeft(int block);
	static int getBoundRight(int block);
	static int getBoundTop(int block);
	static int getBoundBottom(int block);

	static int align(int block);
	static int rotate(int block);

private:
	static Point const tilePositions[BLOCK_TOTAL_NUM][TILE_NUM];
	static int const boundLefts[BLOCK_TOTAL_NUM];
	static int const boundRights[BLOCK_TOTAL_NUM];
	static int const aligns[BLOCK_TOTAL_NUM];
	static int const rotateCCWs[BLOCK_TOTAL_NUM];
	//static int const rotateCWs[BLOCK_TOTAL_NUM];
};


inline Point const &Block::getTilePosition(int const block, int const tile)
{
	return tilePositions[block][tile];
}

inline int Block::getBoundLeft(int const block)
{
	return boundLefts[block];
}

inline int Block::getBoundRight(int const block)
{
	return boundRights[block];
}

inline int Block::getBoundTop(int const block)
{
	return tilePositions[block][0].y;
}

inline int Block::getBoundBottom(int const block)
{
	return tilePositions[block][TILE_NUM - 1].y;
}

inline int Block::align(int const block)
{
	return aligns[block];
}

inline int Block::rotate(int const block)
{
	return rotateCCWs[block];
}

#endif
